/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.iam.AccountUsersService;
import com.databricks.sdk.service.iam.DeleteAccountUserRequest;
import com.databricks.sdk.service.iam.GetAccountUserRequest;
import com.databricks.sdk.service.iam.ListAccountUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PartialUpdate;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class AccountUsersImpl
implements AccountUsersService {
    private final ApiClient apiClient;

    public AccountUsersImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(User request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public User get(GetAccountUserRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListUsersResponse list(ListAccountUsersRequest request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users", this.apiClient.configuredAccountID());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            return this.apiClient.execute(req, ListUsersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PartialUpdate request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(User request) {
        String path = String.format("/api/2.0/accounts/%s/scim/v2/Users/%s", this.apiClient.configuredAccountID(), request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Content-Type", "application/json");
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

