package com.databricks.sdk.core;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;

class ConfigAttributeAccessor {
  private ConfigAttribute configAttribute;
  private Field field;

  public ConfigAttributeAccessor(ConfigAttribute configAttribute, Field field) {
    this.configAttribute = configAttribute;
    this.field = field;
  }

  public String getName() {
    return configAttribute.value();
  }

  public String getEnvVariable() {
    return configAttribute.env();
  }

  public Boolean isSensitive() {
    return configAttribute.sensitive();
  }

  public String getEnv(Map<String, String> getEnv) {
    if (configAttribute.env().isEmpty()) {
      return "";
    }
    return getEnv.get(configAttribute.env());
  }

  public void setValueOnConfig(DatabricksConfig cfg, String value) throws IllegalAccessException {
    field.setAccessible(true);
    if (field.getType() == String.class) {
      field.set(cfg, value);
    } else if (field.getType() == int.class) {
      field.set(cfg, Integer.parseInt(value));
    } else if (field.getType() == boolean.class) {
      field.set(cfg, Boolean.parseBoolean(value));
    }
    field.setAccessible(false);
  }

  public Object getValueFromConfig(DatabricksConfig cfg) throws IllegalAccessException {
    field.setAccessible(true);
    Object value = field.get(cfg);
    field.setAccessible(false);
    return value;
  }

  public String getAuthType() {
    return configAttribute.auth();
  }

  @Override
  public String toString() {
    String repr = configAttribute.value();
    if (!Objects.equals(configAttribute.env(), "")) {
      repr += "(env: " + configAttribute.env() + ")";
    }
    return repr;
  }

  public String getAsString(Object value) {
    String valueToString = value.toString();
    return valueToString;
  }
}
