/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.AzureCliCredentialsProvider;
import com.databricks.sdk.core.BasicCredentialsProvider;
import com.databricks.sdk.core.ClientType;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksCliCredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.GoogleCredentialsCredentialsProvider;
import com.databricks.sdk.core.GoogleIdCredentialsProvider;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.NotebookNativeCredentialsProvider;
import com.databricks.sdk.core.PatCredentialsProvider;
import com.databricks.sdk.core.oauth.AzureDevOpsIDTokenSource;
import com.databricks.sdk.core.oauth.AzureGithubOidcCredentialsProvider;
import com.databricks.sdk.core.oauth.AzureServicePrincipalCredentialsProvider;
import com.databricks.sdk.core.oauth.DatabricksOAuthTokenSource;
import com.databricks.sdk.core.oauth.EnvVarIDTokenSource;
import com.databricks.sdk.core.oauth.ExternalBrowserCredentialsProvider;
import com.databricks.sdk.core.oauth.FileIDTokenSource;
import com.databricks.sdk.core.oauth.GithubIDTokenSource;
import com.databricks.sdk.core.oauth.IDTokenSource;
import com.databricks.sdk.core.oauth.OAuthM2MServicePrincipalCredentialsProvider;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.core.oauth.TokenSourceCredentialsProvider;
import com.databricks.sdk.support.InternalApi;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalApi
public class DefaultCredentialsProvider
implements CredentialsProvider {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCredentialsProvider.class);
    private List<CredentialsProvider> providers = new ArrayList<CredentialsProvider>();
    private String authType = "default";

    @Override
    public String authType() {
        return this.authType;
    }

    @Override
    public synchronized HeaderFactory configure(DatabricksConfig config) {
        this.addDefaultCredentialsProviders(config);
        for (CredentialsProvider provider : this.providers) {
            if (config.getAuthType() != null && !config.getAuthType().isEmpty() && !provider.authType().equals(config.getAuthType())) {
                LOG.info("Ignoring {} auth, because {} is preferred", (Object)provider.authType(), (Object)config.getAuthType());
                continue;
            }
            try {
                LOG.info("Trying {} auth", (Object)provider.authType());
                HeaderFactory headerFactory = provider.configure(config);
                if (headerFactory == null) continue;
                this.authType = provider.authType();
                return headerFactory;
            }
            catch (DatabricksException e) {
                throw new DatabricksException(String.format("%s: %s", provider.authType(), e.getMessage()), e);
            }
        }
        String authFlowUrl = "https://docs.databricks.com/en/dev-tools/auth.html#databricks-client-unified-authentication";
        throw new DatabricksException("cannot configure default credentials, please check " + authFlowUrl + " to configure credentials for your preferred authentication method");
    }

    private void addOIDCCredentialsProviders(DatabricksConfig config) {
        OpenIDConnectEndpoints endpoints = null;
        try {
            endpoints = config.getOidcEndpoints();
        }
        catch (Exception e) {
            LOG.warn("Failed to get OpenID Connect endpoints", (Throwable)e);
        }
        ArrayList<NamedIDTokenSource> namedIdTokenSources = new ArrayList<NamedIDTokenSource>();
        namedIdTokenSources.add(new NamedIDTokenSource("env-oidc", new EnvVarIDTokenSource(Strings.isNullOrEmpty((String)config.getOidcTokenEnv()) ? "DATABRICKS_OIDC_TOKEN" : config.getOidcTokenEnv(), config.getEnv())));
        namedIdTokenSources.add(new NamedIDTokenSource("file-oidc", new FileIDTokenSource(config.getOidcTokenFilepath())));
        namedIdTokenSources.add(new NamedIDTokenSource("github-oidc", new GithubIDTokenSource(config.getActionsIdTokenRequestUrl(), config.getActionsIdTokenRequestToken(), config.getHttpClient())));
        try {
            namedIdTokenSources.add(new NamedIDTokenSource("azure-devops-oidc", new AzureDevOpsIDTokenSource(config.getHttpClient())));
        }
        catch (DatabricksException e) {
            LOG.debug("Azure DevOps OIDC provider not available: {}", (Object)e.getMessage());
        }
        for (NamedIDTokenSource namedIdTokenSource : namedIdTokenSources) {
            DatabricksOAuthTokenSource oauthTokenSource = new DatabricksOAuthTokenSource.Builder(config.getClientId(), config.getHost(), endpoints, namedIdTokenSource.idTokenSource, config.getHttpClient()).audience(config.getTokenAudience()).accountId(config.getClientType() == ClientType.ACCOUNT ? config.getAccountId() : null).scopes(config.getScopes()).build();
            this.providers.add(new TokenSourceCredentialsProvider(oauthTokenSource, namedIdTokenSource.name));
        }
    }

    private synchronized void addDefaultCredentialsProviders(DatabricksConfig config) {
        if (!this.providers.isEmpty()) {
            return;
        }
        this.providers.add(new PatCredentialsProvider());
        this.providers.add(new BasicCredentialsProvider());
        this.providers.add(new OAuthM2MServicePrincipalCredentialsProvider());
        this.addOIDCCredentialsProviders(config);
        this.providers.add(new AzureGithubOidcCredentialsProvider());
        this.providers.add(new AzureServicePrincipalCredentialsProvider());
        this.providers.add(new AzureCliCredentialsProvider());
        this.providers.add(new ExternalBrowserCredentialsProvider());
        this.providers.add(new DatabricksCliCredentialsProvider());
        this.providers.add(new NotebookNativeCredentialsProvider());
        this.providers.add(new GoogleCredentialsCredentialsProvider());
        this.providers.add(new GoogleIdCredentialsProvider());
    }

    private static class NamedIDTokenSource {
        private final String name;
        private final IDTokenSource idTokenSource;

        public NamedIDTokenSource(String name, IDTokenSource idTokenSource) {
            this.name = name;
            this.idTokenSource = idTokenSource;
        }
    }
}

