/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.http;

import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.support.InternalApi;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@InternalApi
public class FormRequest
extends Request {
    public FormRequest(String url, Map<String, String> form) {
        this("POST", url, form);
    }

    public FormRequest(String method, String url, Map<String, String> form) {
        super(method, url, FormRequest.wrapValuesInList(form));
        this.withHeader("Content-Type", "application/x-www-form-urlencoded");
    }

    public static String wrapValuesInList(Map<String, String> map) {
        LinkedHashMap<String, List<String>> m = new LinkedHashMap<String, List<String>>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            m.put(entry.getKey(), Collections.singletonList(entry.getValue()));
        }
        return FormRequest.mapToQuery(m);
    }
}

