/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.oauth.AuthParameterPosition;
import com.databricks.sdk.core.oauth.CachedTokenSource;
import com.databricks.sdk.core.oauth.ClientCredentials;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.support.InternalApi;
import java.io.IOException;

@InternalApi
public class OAuthM2MServicePrincipalCredentialsProvider
implements CredentialsProvider {
    @Override
    public String authType() {
        return "oauth-m2m";
    }

    @Override
    public OAuthHeaderFactory configure(DatabricksConfig config) {
        if (config.getClientId() == null || config.getClientSecret() == null || config.getHost() == null) {
            return null;
        }
        try {
            OpenIDConnectEndpoints jsonResponse = config.getOidcEndpoints();
            ClientCredentials clientCredentials = new ClientCredentials.Builder().withHttpClient(config.getHttpClient()).withClientId(config.getClientId()).withClientSecret(config.getClientSecret()).withTokenUrl(jsonResponse.getTokenEndpoint()).withScopes(config.getScopes()).withAuthParameterPosition(AuthParameterPosition.HEADER).build();
            CachedTokenSource cachedTokenSource = new CachedTokenSource.Builder(clientCredentials).setAsyncDisabled(config.getDisableAsyncTokenRefresh()).build();
            return OAuthHeaderFactory.fromTokenSource(cachedTokenSource);
        }
        catch (IOException e) {
            throw new DatabricksException("Unable to fetch OIDC endpoint: " + e.getMessage(), e);
        }
    }
}

