package com.databricks.sdk.core.error.details;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.List;
import java.util.Optional;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_ErrorDetails extends ErrorDetails {

  private final Optional<ErrorInfo> errorInfo;

  private final Optional<RequestInfo> requestInfo;

  private final Optional<RetryInfo> retryInfo;

  private final Optional<DebugInfo> debugInfo;

  private final Optional<QuotaFailure> quotaFailure;

  private final Optional<PreconditionFailure> preconditionFailure;

  private final Optional<BadRequest> badRequest;

  private final Optional<ResourceInfo> resourceInfo;

  private final Optional<Help> help;

  private final List<JsonNode> unknownDetails;

  private AutoValue_ErrorDetails(
      Optional<ErrorInfo> errorInfo,
      Optional<RequestInfo> requestInfo,
      Optional<RetryInfo> retryInfo,
      Optional<DebugInfo> debugInfo,
      Optional<QuotaFailure> quotaFailure,
      Optional<PreconditionFailure> preconditionFailure,
      Optional<BadRequest> badRequest,
      Optional<ResourceInfo> resourceInfo,
      Optional<Help> help,
      List<JsonNode> unknownDetails) {
    this.errorInfo = errorInfo;
    this.requestInfo = requestInfo;
    this.retryInfo = retryInfo;
    this.debugInfo = debugInfo;
    this.quotaFailure = quotaFailure;
    this.preconditionFailure = preconditionFailure;
    this.badRequest = badRequest;
    this.resourceInfo = resourceInfo;
    this.help = help;
    this.unknownDetails = unknownDetails;
  }

  @Override
  public Optional<ErrorInfo> errorInfo() {
    return errorInfo;
  }

  @Override
  public Optional<RequestInfo> requestInfo() {
    return requestInfo;
  }

  @Override
  public Optional<RetryInfo> retryInfo() {
    return retryInfo;
  }

  @Override
  public Optional<DebugInfo> debugInfo() {
    return debugInfo;
  }

  @Override
  public Optional<QuotaFailure> quotaFailure() {
    return quotaFailure;
  }

  @Override
  public Optional<PreconditionFailure> preconditionFailure() {
    return preconditionFailure;
  }

  @Override
  public Optional<BadRequest> badRequest() {
    return badRequest;
  }

  @Override
  public Optional<ResourceInfo> resourceInfo() {
    return resourceInfo;
  }

  @Override
  public Optional<Help> help() {
    return help;
  }

  @Override
  public List<JsonNode> unknownDetails() {
    return unknownDetails;
  }

  @Override
  public String toString() {
    return "ErrorDetails{"
        + "errorInfo=" + errorInfo + ", "
        + "requestInfo=" + requestInfo + ", "
        + "retryInfo=" + retryInfo + ", "
        + "debugInfo=" + debugInfo + ", "
        + "quotaFailure=" + quotaFailure + ", "
        + "preconditionFailure=" + preconditionFailure + ", "
        + "badRequest=" + badRequest + ", "
        + "resourceInfo=" + resourceInfo + ", "
        + "help=" + help + ", "
        + "unknownDetails=" + unknownDetails
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof ErrorDetails) {
      ErrorDetails that = (ErrorDetails) o;
      return this.errorInfo.equals(that.errorInfo())
          && this.requestInfo.equals(that.requestInfo())
          && this.retryInfo.equals(that.retryInfo())
          && this.debugInfo.equals(that.debugInfo())
          && this.quotaFailure.equals(that.quotaFailure())
          && this.preconditionFailure.equals(that.preconditionFailure())
          && this.badRequest.equals(that.badRequest())
          && this.resourceInfo.equals(that.resourceInfo())
          && this.help.equals(that.help())
          && this.unknownDetails.equals(that.unknownDetails());
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= errorInfo.hashCode();
    h$ *= 1000003;
    h$ ^= requestInfo.hashCode();
    h$ *= 1000003;
    h$ ^= retryInfo.hashCode();
    h$ *= 1000003;
    h$ ^= debugInfo.hashCode();
    h$ *= 1000003;
    h$ ^= quotaFailure.hashCode();
    h$ *= 1000003;
    h$ ^= preconditionFailure.hashCode();
    h$ *= 1000003;
    h$ ^= badRequest.hashCode();
    h$ *= 1000003;
    h$ ^= resourceInfo.hashCode();
    h$ *= 1000003;
    h$ ^= help.hashCode();
    h$ *= 1000003;
    h$ ^= unknownDetails.hashCode();
    return h$;
  }

  static final class Builder extends ErrorDetails.Builder {
    private Optional<ErrorInfo> errorInfo = Optional.empty();
    private Optional<RequestInfo> requestInfo = Optional.empty();
    private Optional<RetryInfo> retryInfo = Optional.empty();
    private Optional<DebugInfo> debugInfo = Optional.empty();
    private Optional<QuotaFailure> quotaFailure = Optional.empty();
    private Optional<PreconditionFailure> preconditionFailure = Optional.empty();
    private Optional<BadRequest> badRequest = Optional.empty();
    private Optional<ResourceInfo> resourceInfo = Optional.empty();
    private Optional<Help> help = Optional.empty();
    private List<JsonNode> unknownDetails;
    Builder() {
    }
    @Override
    public ErrorDetails.Builder setErrorInfo(ErrorInfo errorInfo) {
      this.errorInfo = Optional.of(errorInfo);
      return this;
    }
    @Override
    public ErrorDetails.Builder setRequestInfo(RequestInfo requestInfo) {
      this.requestInfo = Optional.of(requestInfo);
      return this;
    }
    @Override
    public ErrorDetails.Builder setRetryInfo(RetryInfo retryInfo) {
      this.retryInfo = Optional.of(retryInfo);
      return this;
    }
    @Override
    public ErrorDetails.Builder setDebugInfo(DebugInfo debugInfo) {
      this.debugInfo = Optional.of(debugInfo);
      return this;
    }
    @Override
    public ErrorDetails.Builder setQuotaFailure(QuotaFailure quotaFailure) {
      this.quotaFailure = Optional.of(quotaFailure);
      return this;
    }
    @Override
    public ErrorDetails.Builder setPreconditionFailure(PreconditionFailure preconditionFailure) {
      this.preconditionFailure = Optional.of(preconditionFailure);
      return this;
    }
    @Override
    public ErrorDetails.Builder setBadRequest(BadRequest badRequest) {
      this.badRequest = Optional.of(badRequest);
      return this;
    }
    @Override
    public ErrorDetails.Builder setResourceInfo(ResourceInfo resourceInfo) {
      this.resourceInfo = Optional.of(resourceInfo);
      return this;
    }
    @Override
    public ErrorDetails.Builder setHelp(Help help) {
      this.help = Optional.of(help);
      return this;
    }
    @Override
    public ErrorDetails.Builder setUnknownDetails(List<JsonNode> unknownDetails) {
      if (unknownDetails == null) {
        throw new NullPointerException("Null unknownDetails");
      }
      this.unknownDetails = unknownDetails;
      return this;
    }
    @Override
    public ErrorDetails build() {
      if (this.unknownDetails == null) {
        String missing = " unknownDetails";
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_ErrorDetails(
          this.errorInfo,
          this.requestInfo,
          this.retryInfo,
          this.debugInfo,
          this.quotaFailure,
          this.preconditionFailure,
          this.badRequest,
          this.resourceInfo,
          this.help,
          this.unknownDetails);
    }
  }

}
