/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.DatabricksConfig;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import java.io.IOException;

public class OAuthClientUtils {
    private static final String DEFAULT_CLIENT_ID = "databricks-cli";

    public static String resolveClientId(DatabricksConfig config) {
        if (config.getClientId() != null) {
            return config.getClientId();
        }
        if (config.getAzureClientId() != null) {
            return config.getAzureClientId();
        }
        return DEFAULT_CLIENT_ID;
    }

    public static String resolveClientSecret(DatabricksConfig config) {
        if (config.getClientSecret() != null) {
            return config.getClientSecret();
        }
        if (config.getAzureClientSecret() != null) {
            return config.getAzureClientSecret();
        }
        return null;
    }

    public static OpenIDConnectEndpoints resolveOidcEndpoints(DatabricksConfig config) throws IOException {
        if (config.getClientId() != null && config.getClientSecret() != null) {
            return config.getDatabricksOidcEndpoints();
        }
        if (config.getAzureClientId() != null && config.getAzureClientSecret() != null) {
            Request request = new Request("GET", config.getHost() + "/oidc/oauth2/v2.0/authorize");
            request.setRedirectionBehavior(false);
            Response resp = config.getHttpClient().execute(request);
            String realAuthUrl = resp.getFirstHeader("location");
            if (realAuthUrl == null) {
                return null;
            }
            return new OpenIDConnectEndpoints(realAuthUrl.replaceAll("/authorize", "/token"), realAuthUrl);
        }
        return config.getDatabricksOidcEndpoints();
    }
}

