/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.support.InternalApi;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@InternalApi
public class TokenCacheUtils {
    private static final String BASE_PATH = ".config/databricks-sdk-java/oauth";

    public static Path getCacheFilePath(String host, String clientId, List<String> scopes) {
        try {
            MessageDigest hash = MessageDigest.getInstance("SHA-256");
            for (String chunk : new String[]{host, clientId, String.join((CharSequence)",", scopes)}) {
                hash.update(chunk.getBytes(StandardCharsets.UTF_8));
            }
            StringBuilder hexString = new StringBuilder();
            for (byte b : hash.digest()) {
                String hex = Integer.toHexString(0xFF & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            String userHome = System.getProperty("user.home");
            Path basePath = Paths.get(userHome, BASE_PATH);
            return basePath.resolve(hexString.toString());
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Failed to create hash for token cache filename", e);
        }
    }
}

