/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.utils;

import com.databricks.sdk.support.InternalApi;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.protobuf.Duration;
import com.google.protobuf.FieldMask;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Durations;
import com.google.protobuf.util.Timestamps;
import java.io.IOException;

@InternalApi
public class ProtobufModule
extends SimpleModule {
    public ProtobufModule() {
        super("ProtobufModule");
        this.addSerializer(FieldMask.class, new FieldMaskSerializer());
        this.addDeserializer(FieldMask.class, new FieldMaskDeserializer());
        this.addSerializer(Duration.class, new DurationSerializer());
        this.addDeserializer(Duration.class, new DurationDeserializer());
        this.addSerializer(Timestamp.class, new TimestampSerializer());
        this.addDeserializer(Timestamp.class, new TimestampDeserializer());
    }

    public static class TimestampDeserializer
    extends JsonDeserializer<Timestamp> {
        public Timestamp deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String timestampString = p.getValueAsString();
            if (timestampString == null || timestampString.trim().isEmpty()) {
                return Timestamp.getDefaultInstance();
            }
            try {
                return Timestamps.parse((String)timestampString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid timestamp format: " + timestampString, e);
            }
        }
    }

    public static class TimestampSerializer
    extends JsonSerializer<Timestamp> {
        public void serialize(Timestamp timestamp, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Timestamps.toString((Timestamp)timestamp));
        }
    }

    public static class DurationDeserializer
    extends JsonDeserializer<Duration> {
        public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String durationString = p.getValueAsString();
            if (durationString == null || durationString.trim().isEmpty()) {
                return Duration.getDefaultInstance();
            }
            try {
                return Durations.parse((String)durationString.trim());
            }
            catch (Exception e) {
                throw new IOException("Invalid duration format: " + durationString, e);
            }
        }
    }

    public static class DurationSerializer
    extends JsonSerializer<Duration> {
        public void serialize(Duration duration, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(Durations.toString((Duration)duration));
        }
    }

    public static class FieldMaskDeserializer
    extends JsonDeserializer<FieldMask> {
        public FieldMask deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            String[] paths;
            String pathsString = p.getValueAsString();
            if (pathsString == null || pathsString.trim().isEmpty()) {
                return FieldMask.getDefaultInstance();
            }
            FieldMask.Builder builder = FieldMask.newBuilder();
            for (String path : paths = pathsString.split(",")) {
                String trimmedPath = path.trim();
                if (trimmedPath.isEmpty()) continue;
                builder.addPaths(trimmedPath);
            }
            return builder.build();
        }
    }

    public static class FieldMaskSerializer
    extends JsonSerializer<FieldMask> {
        public void serialize(FieldMask fieldMask, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(String.join((CharSequence)",", (Iterable<? extends CharSequence>)fieldMask.getPathsList()));
        }
    }
}

