/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.CatalogInfo;
import com.databricks.sdk.service.catalog.CatalogsImpl;
import com.databricks.sdk.service.catalog.CatalogsService;
import com.databricks.sdk.service.catalog.CreateCatalog;
import com.databricks.sdk.service.catalog.DeleteCatalogRequest;
import com.databricks.sdk.service.catalog.GetCatalogRequest;
import com.databricks.sdk.service.catalog.ListCatalogsRequest;
import com.databricks.sdk.service.catalog.ListCatalogsResponse;
import com.databricks.sdk.service.catalog.UpdateCatalog;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class CatalogsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogsAPI.class);
    private final CatalogsService impl;

    public CatalogsAPI(ApiClient apiClient) {
        this.impl = new CatalogsImpl(apiClient);
    }

    public CatalogsAPI(CatalogsService mock) {
        this.impl = mock;
    }

    public CatalogInfo create(CreateCatalog request) {
        return this.impl.create(request);
    }

    public void delete(String name) {
        this.delete(new DeleteCatalogRequest().setName(name));
    }

    public void delete(DeleteCatalogRequest request) {
        this.impl.delete(request);
    }

    public CatalogInfo get(String name) {
        return this.get(new GetCatalogRequest().setName(name));
    }

    public CatalogInfo get(GetCatalogRequest request) {
        return this.impl.get(request);
    }

    public Iterable<CatalogInfo> list(ListCatalogsRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::list, ListCatalogsResponse::getCatalogs, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public CatalogInfo update(UpdateCatalog request) {
        return this.impl.update(request);
    }

    public CatalogsService impl() {
        return this.impl;
    }
}

