/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.CreatePolicyRequest;
import com.databricks.sdk.service.catalog.DeletePolicyRequest;
import com.databricks.sdk.service.catalog.DeletePolicyResponse;
import com.databricks.sdk.service.catalog.GetPolicyRequest;
import com.databricks.sdk.service.catalog.ListPoliciesRequest;
import com.databricks.sdk.service.catalog.ListPoliciesResponse;
import com.databricks.sdk.service.catalog.PoliciesService;
import com.databricks.sdk.service.catalog.PolicyInfo;
import com.databricks.sdk.service.catalog.UpdatePolicyRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class PoliciesImpl
implements PoliciesService {
    private final ApiClient apiClient;

    public PoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public PolicyInfo createPolicy(CreatePolicyRequest request) {
        String path = "/api/2.1/unity-catalog/policies";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request.getPolicyInfo()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PolicyInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public DeletePolicyResponse deletePolicy(DeletePolicyRequest request) {
        String path = String.format("/api/2.1/unity-catalog/policies/%s/%s/%s", request.getOnSecurableType(), request.getOnSecurableFullname(), request.getName());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, DeletePolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PolicyInfo getPolicy(GetPolicyRequest request) {
        String path = String.format("/api/2.1/unity-catalog/policies/%s/%s/%s", request.getOnSecurableType(), request.getOnSecurableFullname(), request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PolicyInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPoliciesResponse listPolicies(ListPoliciesRequest request) {
        String path = String.format("/api/2.1/unity-catalog/policies/%s/%s", request.getOnSecurableType(), request.getOnSecurableFullname());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PolicyInfo updatePolicy(UpdatePolicyRequest request) {
        String path = String.format("/api/2.1/unity-catalog/policies/%s/%s/%s", request.getOnSecurableType(), request.getOnSecurableFullname(), request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getPolicyInfo()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PolicyInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

