/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.GetQuotaRequest;
import com.databricks.sdk.service.catalog.GetQuotaResponse;
import com.databricks.sdk.service.catalog.ListQuotasRequest;
import com.databricks.sdk.service.catalog.ListQuotasResponse;
import com.databricks.sdk.service.catalog.ResourceQuotasService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ResourceQuotasImpl
implements ResourceQuotasService {
    private final ApiClient apiClient;

    public ResourceQuotasImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public GetQuotaResponse getQuota(GetQuotaRequest request) {
        String path = String.format("/api/2.1/unity-catalog/resource-quotas/%s/%s/%s", request.getParentSecurableType(), request.getParentFullName(), request.getQuotaName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetQuotaResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListQuotasResponse listQuotas(ListQuotasRequest request) {
        String path = "/api/2.1/unity-catalog/resource-quotas/all-resource-quotas";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListQuotasResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

