/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.catalog.GetBindingsRequest;
import com.databricks.sdk.service.catalog.GetCatalogWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.GetWorkspaceBindingRequest;
import com.databricks.sdk.service.catalog.GetWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.UpdateCatalogWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindings;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsParameters;
import com.databricks.sdk.service.catalog.UpdateWorkspaceBindingsResponse;
import com.databricks.sdk.service.catalog.WorkspaceBinding;
import com.databricks.sdk.service.catalog.WorkspaceBindingsImpl;
import com.databricks.sdk.service.catalog.WorkspaceBindingsService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspaceBindingsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceBindingsAPI.class);
    private final WorkspaceBindingsService impl;

    public WorkspaceBindingsAPI(ApiClient apiClient) {
        this.impl = new WorkspaceBindingsImpl(apiClient);
    }

    public WorkspaceBindingsAPI(WorkspaceBindingsService mock) {
        this.impl = mock;
    }

    public GetCatalogWorkspaceBindingsResponse get(String name) {
        return this.get(new GetWorkspaceBindingRequest().setName(name));
    }

    public GetCatalogWorkspaceBindingsResponse get(GetWorkspaceBindingRequest request) {
        return this.impl.get(request);
    }

    public Iterable<WorkspaceBinding> getBindings(String securableType, String securableName) {
        return this.getBindings(new GetBindingsRequest().setSecurableType(securableType).setSecurableName(securableName));
    }

    public Iterable<WorkspaceBinding> getBindings(GetBindingsRequest request) {
        if (request.getMaxResults() == null) {
            request.setMaxResults(0L);
        }
        return new Paginator(request, this.impl::getBindings, GetWorkspaceBindingsResponse::getBindings, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public UpdateCatalogWorkspaceBindingsResponse update(UpdateWorkspaceBindings request) {
        return this.impl.update(request);
    }

    public UpdateWorkspaceBindingsResponse updateBindings(UpdateWorkspaceBindingsParameters request) {
        return this.impl.updateBindings(request);
    }

    public WorkspaceBindingsService impl() {
        return this.impl;
    }
}

