/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.iam;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.iam.CreateUserRequest;
import com.databricks.sdk.service.iam.DeleteUserRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsRequest;
import com.databricks.sdk.service.iam.GetPasswordPermissionLevelsResponse;
import com.databricks.sdk.service.iam.GetPasswordPermissionsRequest;
import com.databricks.sdk.service.iam.GetUserRequest;
import com.databricks.sdk.service.iam.ListUsersRequest;
import com.databricks.sdk.service.iam.ListUsersResponse;
import com.databricks.sdk.service.iam.PasswordPermissions;
import com.databricks.sdk.service.iam.PasswordPermissionsRequest;
import com.databricks.sdk.service.iam.PatchUserRequest;
import com.databricks.sdk.service.iam.UpdateUserRequest;
import com.databricks.sdk.service.iam.User;
import com.databricks.sdk.service.iam.UsersV2Service;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class UsersV2Impl
implements UsersV2Service {
    private final ApiClient apiClient;

    public UsersV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public User create(CreateUserRequest request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public User get(GetUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, User.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetPasswordPermissionLevelsResponse getPermissionLevels(GetPasswordPermissionLevelsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords/permissionLevels";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetPasswordPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions getPermissions(GetPasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListUsersResponse list(ListUsersRequest request) {
        String path = "/api/2.0/preview/scim/v2/Users";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListUsersResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void patch(PatchUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions setPermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void update(UpdateUserRequest request) {
        String path = String.format("/api/2.0/preview/scim/v2/Users/%s", request.getId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public PasswordPermissions updatePermissions(PasswordPermissionsRequest request) {
        String path = "/api/2.0/permissions/authorization/passwords";
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, PasswordPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

