/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.tags;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.tags.CreateTagAssignmentRequest;
import com.databricks.sdk.service.tags.DeleteTagAssignmentRequest;
import com.databricks.sdk.service.tags.GetTagAssignmentRequest;
import com.databricks.sdk.service.tags.ListTagAssignmentsRequest;
import com.databricks.sdk.service.tags.ListTagAssignmentsResponse;
import com.databricks.sdk.service.tags.TagAssignment;
import com.databricks.sdk.service.tags.UpdateTagAssignmentRequest;
import com.databricks.sdk.service.tags.WorkspaceEntityTagAssignmentsImpl;
import com.databricks.sdk.service.tags.WorkspaceEntityTagAssignmentsService;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class WorkspaceEntityTagAssignmentsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(WorkspaceEntityTagAssignmentsAPI.class);
    private final WorkspaceEntityTagAssignmentsService impl;

    public WorkspaceEntityTagAssignmentsAPI(ApiClient apiClient) {
        this.impl = new WorkspaceEntityTagAssignmentsImpl(apiClient);
    }

    public WorkspaceEntityTagAssignmentsAPI(WorkspaceEntityTagAssignmentsService mock) {
        this.impl = mock;
    }

    public TagAssignment createTagAssignment(CreateTagAssignmentRequest request) {
        return this.impl.createTagAssignment(request);
    }

    public void deleteTagAssignment(String entityType, String entityId, String tagKey) {
        this.deleteTagAssignment(new DeleteTagAssignmentRequest().setEntityType(entityType).setEntityId(entityId).setTagKey(tagKey));
    }

    public void deleteTagAssignment(DeleteTagAssignmentRequest request) {
        this.impl.deleteTagAssignment(request);
    }

    public TagAssignment getTagAssignment(String entityType, String entityId, String tagKey) {
        return this.getTagAssignment(new GetTagAssignmentRequest().setEntityType(entityType).setEntityId(entityId).setTagKey(tagKey));
    }

    public TagAssignment getTagAssignment(GetTagAssignmentRequest request) {
        return this.impl.getTagAssignment(request);
    }

    public Iterable<TagAssignment> listTagAssignments(String entityType, String entityId) {
        return this.listTagAssignments(new ListTagAssignmentsRequest().setEntityType(entityType).setEntityId(entityId));
    }

    public Iterable<TagAssignment> listTagAssignments(ListTagAssignmentsRequest request) {
        return new Paginator(request, this.impl::listTagAssignments, ListTagAssignmentsResponse::getTagAssignments, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public TagAssignment updateTagAssignment(UpdateTagAssignmentRequest request) {
        return this.impl.updateTagAssignment(request);
    }

    public WorkspaceEntityTagAssignmentsService impl() {
        return this.impl;
    }
}

