/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.AzureEnvironment;
import com.databricks.sdk.core.ClientType;
import com.databricks.sdk.core.ConfigAttribute;
import com.databricks.sdk.core.ConfigLoader;
import com.databricks.sdk.core.CredentialsProvider;
import com.databricks.sdk.core.DatabricksEnvironment;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.DefaultCredentialsProvider;
import com.databricks.sdk.core.HeaderFactory;
import com.databricks.sdk.core.HostType;
import com.databricks.sdk.core.commons.CommonsHttpClient;
import com.databricks.sdk.core.http.HttpClient;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.http.Response;
import com.databricks.sdk.core.oauth.ErrorTokenSource;
import com.databricks.sdk.core.oauth.OAuthHeaderFactory;
import com.databricks.sdk.core.oauth.OpenIDConnectEndpoints;
import com.databricks.sdk.core.oauth.TokenSource;
import com.databricks.sdk.core.utils.Cloud;
import com.databricks.sdk.core.utils.Environment;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.http.HttpMessage;

public class DatabricksConfig {
    private CredentialsProvider credentialsProvider = new DefaultCredentialsProvider();
    @ConfigAttribute(env="DATABRICKS_HOST")
    private String host;
    @ConfigAttribute(env="DATABRICKS_ACCOUNT_ID")
    private String accountId;
    @ConfigAttribute(env="DATABRICKS_WORKSPACE_ID")
    private String workspaceId;
    @ConfigAttribute(env="DATABRICKS_EXPERIMENTAL_IS_UNIFIED_HOST")
    private Boolean experimentalIsUnifiedHost;
    @ConfigAttribute(env="DATABRICKS_TOKEN", auth="pat", sensitive=true)
    private String token;
    @ConfigAttribute(env="DATABRICKS_CLIENT_ID", auth="oauth")
    private String clientId;
    @ConfigAttribute(env="DATABRICKS_CLIENT_SECRET", auth="oauth", sensitive=true)
    private String clientSecret;
    @ConfigAttribute(auth="oauth")
    private List<String> scopes;
    @ConfigAttribute(env="DATABRICKS_REDIRECT_URL", auth="oauth")
    private String redirectUrl;
    @ConfigAttribute(env="DATABRICKS_DISCOVERY_URL")
    private String discoveryUrl;
    @ConfigAttribute(env="DATABRICKS_USERNAME", auth="basic")
    private String username;
    @ConfigAttribute(env="DATABRICKS_PASSWORD", auth="basic", sensitive=true)
    private String password;
    @ConfigAttribute(env="DATABRICKS_CONFIG_PROFILE")
    private String profile;
    @ConfigAttribute(env="DATABRICKS_CONFIG_FILE")
    private String configFile;
    @ConfigAttribute(env="DATABRICKS_CLUSTER_ID")
    private String clusterId;
    @ConfigAttribute(env="DATABRICKS_SERVERLESS_COMPUTE_ID")
    private String serverlessComputeId;
    @ConfigAttribute(env="DATABRICKS_GOOGLE_SERVICE_ACCOUNT", auth="google")
    private String googleServiceAccount;
    @ConfigAttribute(env="GOOGLE_CREDENTIALS", auth="google", sensitive=true)
    private String googleCredentials;
    @ConfigAttribute(env="DATABRICKS_AZURE_RESOURCE_ID", auth="azure")
    private String azureWorkspaceResourceId;
    @ConfigAttribute(env="ARM_USE_MSI", auth="azure")
    private Boolean azureUseMsi;
    @ConfigAttribute(env="ARM_CLIENT_SECRET", auth="azure", sensitive=true)
    private String azureClientSecret;
    @ConfigAttribute(env="ARM_CLIENT_ID", auth="azure")
    private String azureClientId;
    @ConfigAttribute(env="ARM_TENANT_ID", auth="azure")
    private String azureTenantId;
    @ConfigAttribute(env="ARM_ENVIRONMENT")
    private String azureEnvironment;
    @ConfigAttribute(env="ACTIONS_ID_TOKEN_REQUEST_URL")
    private String actionsIdTokenRequestUrl;
    @ConfigAttribute(env="ACTIONS_ID_TOKEN_REQUEST_TOKEN")
    private String actionsIdTokenRequestToken;
    @ConfigAttribute(env="DATABRICKS_CLI_PATH")
    private String databricksCliPath;
    @ConfigAttribute(env="DATABRICKS_AUTH_TYPE")
    private String authType;
    @ConfigAttribute
    private Boolean skipVerify;
    @ConfigAttribute
    private Integer httpTimeoutSeconds;
    @ConfigAttribute(env="DATABRICKS_DEBUG_TRUNCATE_BYTES")
    private Integer debugTruncateBytes;
    @ConfigAttribute(env="DATABRICKS_DEBUG_HEADERS")
    private Boolean debugHeaders;
    @ConfigAttribute(env="DATABRICKS_RATE_LIMIT")
    private Integer rateLimit;
    private volatile boolean resolved;
    private HeaderFactory headerFactory;
    private HttpClient httpClient;
    private Environment env;
    private DatabricksEnvironment databricksEnvironment;
    @ConfigAttribute(env="TOKEN_AUDIENCE")
    private String tokenAudience;
    @ConfigAttribute(env="DATABRICKS_OIDC_TOKEN_FILEPATH", auth="file-oidc")
    private String oidcTokenFilepath;
    @ConfigAttribute(env="DATABRICKS_OIDC_TOKEN_ENV", auth="env-oidc")
    private String oidcTokenEnv;
    @ConfigAttribute(env="DATABRICKS_DISABLE_ASYNC_TOKEN_REFRESH")
    private Boolean disableAsyncTokenRefresh;
    @ConfigAttribute(env="DATABRICKS_DISABLE_RETRIES")
    private Boolean disableRetries;
    @ConfigAttribute(env="DATABRICKS_OAUTH_BROWSER_AUTH_TIMEOUT")
    private Duration oauthBrowserAuthTimeout;
    @ConfigAttribute(env="DATABRICKS_DISABLE_OAUTH_REFRESH_TOKEN")
    private Boolean disableOauthRefreshToken;

    public Environment getEnv() {
        return this.env;
    }

    public synchronized DatabricksConfig resolve() {
        String[] path = System.getenv("PATH").split(File.pathSeparator);
        Environment env = new Environment(System.getenv(), path, System.getProperty("os.name"));
        return this.resolve(env);
    }

    synchronized DatabricksConfig resolve(Environment env) {
        this.env = env;
        this.innerResolve();
        return this;
    }

    private synchronized DatabricksConfig innerResolve() {
        Objects.requireNonNull(this.env);
        try {
            ConfigLoader.resolve(this);
            ConfigLoader.validate(this);
            this.sortScopes();
            ConfigLoader.fixHostIfNeeded(this);
            this.initHttp();
            return this;
        }
        catch (DatabricksException e) {
            throw ConfigLoader.makeNicerError(e.getMessage(), e, this);
        }
    }

    private void sortScopes() {
        if (this.scopes != null && !this.scopes.isEmpty()) {
            Collections.sort(this.scopes);
        }
    }

    private void initHttp() {
        if (this.httpClient != null) {
            return;
        }
        this.httpClient = new CommonsHttpClient.Builder().withDatabricksConfig(this).build();
    }

    public synchronized Map<String, String> authenticate() throws DatabricksException {
        try {
            if (this.headerFactory == null) {
                ConfigLoader.fixHostIfNeeded(this);
                this.headerFactory = this.credentialsProvider.configure(this);
                this.setAuthType(this.credentialsProvider.authType());
            }
            HashMap<String, String> headers = new HashMap<String, String>(this.headerFactory.headers());
            if (this.getHostType() == HostType.UNIFIED && this.workspaceId != null && !this.workspaceId.isEmpty()) {
                headers.put("X-Databricks-Org-Id", this.workspaceId);
            }
            return headers;
        }
        catch (DatabricksException e) {
            String msg = String.format("%s auth: %s", this.credentialsProvider.authType(), e.getMessage());
            DatabricksException wrapperException = new DatabricksException(msg, e);
            throw ConfigLoader.makeNicerError(wrapperException.getMessage(), wrapperException, this);
        }
    }

    public TokenSource getTokenSource() {
        if (this.headerFactory == null) {
            try {
                ConfigLoader.fixHostIfNeeded(this);
                this.headerFactory = this.credentialsProvider.configure(this);
            }
            catch (Exception e) {
                return new ErrorTokenSource("Failed to get token source: " + e.getMessage());
            }
            this.setAuthType(this.credentialsProvider.authType());
        }
        if (this.headerFactory instanceof OAuthHeaderFactory) {
            return (TokenSource)((Object)this.headerFactory);
        }
        return new ErrorTokenSource(String.format("OAuth Token not supported for current auth type %s", this.authType));
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public DatabricksConfig setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public DatabricksConfig setHost(String host) {
        this.host = host;
        return this;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public DatabricksConfig setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
        return this;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public DatabricksConfig setAccountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public DatabricksConfig setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
        return this;
    }

    public Boolean getExperimentalIsUnifiedHost() {
        return this.experimentalIsUnifiedHost;
    }

    public DatabricksConfig setExperimentalIsUnifiedHost(Boolean experimentalIsUnifiedHost) {
        this.experimentalIsUnifiedHost = experimentalIsUnifiedHost;
        return this;
    }

    public String getDatabricksCliPath() {
        return this.databricksCliPath;
    }

    public DatabricksConfig setDatabricksCliPath(String databricksCliPath) {
        this.databricksCliPath = databricksCliPath;
        return this;
    }

    public String getToken() {
        return this.token;
    }

    public DatabricksConfig setToken(String token) {
        this.token = token;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public DatabricksConfig setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public DatabricksConfig setClusterId(String clusterId) {
        this.clusterId = clusterId;
        return this;
    }

    public String getServerlessComputeId() {
        return this.serverlessComputeId;
    }

    public DatabricksConfig setServerlessComputeId(String serverlessComputeId) {
        this.serverlessComputeId = serverlessComputeId;
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public DatabricksConfig setPassword(String password) {
        this.password = password;
        return this;
    }

    public String getClientId() {
        return this.clientId;
    }

    public DatabricksConfig setClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public DatabricksConfig setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    public String getOAuthRedirectUrl() {
        return this.redirectUrl;
    }

    public DatabricksConfig setOAuthRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
        return this;
    }

    public List<String> getScopes() {
        if (this.scopes == null || this.scopes.isEmpty()) {
            return Arrays.asList("all-apis");
        }
        return this.scopes;
    }

    public DatabricksConfig setScopes(List<String> scopes) {
        this.scopes = scopes;
        return this;
    }

    public String getProfile() {
        return this.profile;
    }

    public DatabricksConfig setProfile(String profile) {
        this.profile = profile;
        return this;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public DatabricksConfig setConfigFile(String configFile) {
        this.configFile = configFile;
        return this;
    }

    public String getGoogleServiceAccount() {
        return this.googleServiceAccount;
    }

    public DatabricksConfig setGoogleServiceAccount(String googleServiceAccount) {
        this.googleServiceAccount = googleServiceAccount;
        return this;
    }

    public String getGoogleCredentials() {
        return this.googleCredentials;
    }

    public DatabricksConfig setGoogleCredentials(String googleCredentials) {
        this.googleCredentials = googleCredentials;
        return this;
    }

    public String getAzureWorkspaceResourceId() {
        return this.azureWorkspaceResourceId;
    }

    public DatabricksConfig setAzureWorkspaceResourceId(String azureWorkspaceResourceId) {
        this.azureWorkspaceResourceId = azureWorkspaceResourceId;
        return this;
    }

    public boolean getAzureUseMsi() {
        return this.azureUseMsi;
    }

    public DatabricksConfig setAzureUseMsi(boolean azureUseMsi) {
        this.azureUseMsi = azureUseMsi;
        return this;
    }

    @Deprecated
    public boolean getAzureUseMSI() {
        return this.azureUseMsi;
    }

    @Deprecated
    public DatabricksConfig setAzureUseMSI(boolean azureUseMsi) {
        this.azureUseMsi = azureUseMsi;
        return this;
    }

    public String getAzureClientSecret() {
        return this.azureClientSecret;
    }

    public DatabricksConfig setAzureClientSecret(String azureClientSecret) {
        this.azureClientSecret = azureClientSecret;
        return this;
    }

    public String getAzureClientId() {
        return this.azureClientId;
    }

    public DatabricksConfig setAzureClientId(String azureClientId) {
        this.azureClientId = azureClientId;
        return this;
    }

    public String getAzureTenantId() {
        return this.azureTenantId;
    }

    public DatabricksConfig setAzureTenantId(String azureTenantId) {
        this.azureTenantId = azureTenantId;
        return this;
    }

    public AzureEnvironment getAzureEnvironment() {
        String env = "PUBLIC";
        if (this.azureEnvironment != null) {
            env = this.azureEnvironment;
        }
        return AzureEnvironment.getEnvironment(env);
    }

    public DatabricksConfig setAzureEnvironment(String azureEnvironment) {
        this.azureEnvironment = azureEnvironment;
        return this;
    }

    public String getActionsIdTokenRequestUrl() {
        return this.actionsIdTokenRequestUrl;
    }

    public DatabricksConfig setActionsIdTokenRequestUrl(String url) {
        this.actionsIdTokenRequestUrl = url;
        return this;
    }

    public String getActionsIdTokenRequestToken() {
        return this.actionsIdTokenRequestToken;
    }

    public DatabricksConfig setActionsIdTokenRequestToken(String token) {
        this.actionsIdTokenRequestToken = token;
        return this;
    }

    public String getEffectiveAzureLoginAppId() {
        return this.getDatabricksEnvironment().getAzureApplicationId();
    }

    public String getAuthType() {
        return this.authType;
    }

    public DatabricksConfig setAuthType(String authType) {
        this.authType = authType;
        return this;
    }

    public boolean isSkipVerify() {
        return this.skipVerify;
    }

    public DatabricksConfig setSkipVerify(boolean skipVerify) {
        this.skipVerify = skipVerify;
        return this;
    }

    public Integer getHttpTimeoutSeconds() {
        return this.httpTimeoutSeconds;
    }

    public DatabricksConfig setHttpTimeoutSeconds(int httpTimeoutSeconds) {
        this.httpTimeoutSeconds = httpTimeoutSeconds;
        return this;
    }

    public Integer getDebugTruncateBytes() {
        return this.debugTruncateBytes;
    }

    public DatabricksConfig setDebugTruncateBytes(int debugTruncateBytes) {
        this.debugTruncateBytes = debugTruncateBytes;
        return this;
    }

    public boolean isDebugHeaders() {
        return this.debugHeaders != null && this.debugHeaders != false;
    }

    public DatabricksConfig setDebugHeaders(boolean debugHeaders) {
        this.debugHeaders = debugHeaders;
        return this;
    }

    public Integer getRateLimit() {
        return this.rateLimit;
    }

    public DatabricksConfig setRateLimit(int rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public DatabricksConfig setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public String getTokenAudience() {
        return this.tokenAudience;
    }

    public DatabricksConfig setTokenAudience(String tokenAudience) {
        this.tokenAudience = tokenAudience;
        return this;
    }

    public String getOidcTokenFilepath() {
        return this.oidcTokenFilepath;
    }

    public DatabricksConfig setOidcTokenFilepath(String oidcTokenFilepath) {
        this.oidcTokenFilepath = oidcTokenFilepath;
        return this;
    }

    public String getOidcTokenEnv() {
        return this.oidcTokenEnv;
    }

    public DatabricksConfig setOidcTokenEnv(String oidcTokenEnv) {
        this.oidcTokenEnv = oidcTokenEnv;
        return this;
    }

    public boolean getDisableAsyncTokenRefresh() {
        return this.disableAsyncTokenRefresh != null && this.disableAsyncTokenRefresh != false;
    }

    public DatabricksConfig setDisableAsyncTokenRefresh(boolean disableAsyncTokenRefresh) {
        this.disableAsyncTokenRefresh = disableAsyncTokenRefresh;
        return this;
    }

    public boolean getDisableRetries() {
        return this.disableRetries != null && this.disableRetries != false;
    }

    public DatabricksConfig setDisableRetries(boolean disableRetries) {
        this.disableRetries = disableRetries;
        return this;
    }

    public Duration getOAuthBrowserAuthTimeout() {
        return this.oauthBrowserAuthTimeout;
    }

    public DatabricksConfig setOAuthBrowserAuthTimeout(Duration oauthBrowserAuthTimeout) {
        this.oauthBrowserAuthTimeout = oauthBrowserAuthTimeout;
        return this;
    }

    public boolean getDisableOauthRefreshToken() {
        return this.disableOauthRefreshToken != null && this.disableOauthRefreshToken != false;
    }

    public DatabricksConfig setDisableOauthRefreshToken(boolean disable) {
        this.disableOauthRefreshToken = disable;
        return this;
    }

    public boolean isAzure() {
        if (this.azureWorkspaceResourceId != null) {
            return true;
        }
        return this.getDatabricksEnvironment().getCloud() == Cloud.AZURE;
    }

    public synchronized void authenticate(HttpMessage request) {
        Map<String, String> headers = this.authenticate();
        for (Map.Entry<String, String> e : headers.entrySet()) {
            request.setHeader(e.getKey(), e.getValue());
        }
    }

    public boolean isGcp() {
        return this.getDatabricksEnvironment().getCloud() == Cloud.GCP;
    }

    public boolean isAws() {
        return this.getDatabricksEnvironment().getCloud() == Cloud.AWS;
    }

    public boolean isAccountClient() {
        if (this.getHostType() == HostType.UNIFIED) {
            throw new DatabricksException("Cannot determine account client status for unified hosts. Use getHostType() or getClientType() instead. For unified hosts, client type depends on whether workspaceId is set.");
        }
        if (this.host == null) {
            return false;
        }
        return this.host.startsWith("https://accounts.") || this.host.startsWith("https://accounts-dod.");
    }

    public HostType getHostType() {
        if (this.experimentalIsUnifiedHost != null && this.experimentalIsUnifiedHost.booleanValue()) {
            return HostType.UNIFIED;
        }
        if (this.host == null) {
            return HostType.WORKSPACE;
        }
        if (this.host.startsWith("https://accounts.") || this.host.startsWith("https://accounts-dod.")) {
            return HostType.ACCOUNTS;
        }
        return HostType.WORKSPACE;
    }

    public ClientType getClientType() {
        HostType hostType = this.getHostType();
        switch (hostType) {
            case UNIFIED: {
                return this.workspaceId != null && !this.workspaceId.isEmpty() ? ClientType.WORKSPACE : ClientType.ACCOUNT;
            }
            case ACCOUNTS: {
                return ClientType.ACCOUNT;
            }
        }
        return ClientType.WORKSPACE;
    }

    @Deprecated
    public OpenIDConnectEndpoints getOidcEndpoints() throws IOException {
        if (this.isAzure() && this.getAzureClientId() != null) {
            return this.getAzureEntraIdWorkspaceEndpoints();
        }
        return this.getDatabricksOidcEndpoints();
    }

    public OpenIDConnectEndpoints getAzureEntraIdWorkspaceEndpoints() throws IOException {
        if (this.isAzure() && this.getAzureClientId() != null) {
            Request request = new Request("GET", this.getHost() + "/oidc/oauth2/v2.0/authorize");
            request.setRedirectionBehavior(false);
            Response resp = this.getHttpClient().execute(request);
            String realAuthUrl = resp.getFirstHeader("location");
            if (realAuthUrl == null) {
                return null;
            }
            return new OpenIDConnectEndpoints(realAuthUrl.replaceAll("/authorize", "/token"), realAuthUrl);
        }
        return null;
    }

    public OpenIDConnectEndpoints getDatabricksOidcEndpoints() throws IOException {
        if (this.discoveryUrl == null) {
            return this.fetchDefaultOidcEndpoints();
        }
        return this.fetchOidcEndpointsFromDiscovery();
    }

    private OpenIDConnectEndpoints fetchOidcEndpointsFromDiscovery() {
        try {
            Request request = new Request("GET", this.discoveryUrl);
            Response resp = this.getHttpClient().execute(request);
            if (resp.getStatusCode() == 200) {
                return (OpenIDConnectEndpoints)new ObjectMapper().readValue(resp.getBody(), OpenIDConnectEndpoints.class);
            }
        }
        catch (IOException e) {
            throw ConfigLoader.makeNicerError(e.getMessage(), e, this);
        }
        return null;
    }

    private OpenIDConnectEndpoints getUnifiedOidcEndpoints(String accountId) throws IOException {
        if (accountId == null || accountId.isEmpty()) {
            throw new DatabricksException("account_id is required for unified host OIDC endpoint discovery");
        }
        String prefix = this.getHost() + "/oidc/accounts/" + accountId;
        return new OpenIDConnectEndpoints(prefix + "/v1/token", prefix + "/v1/authorize");
    }

    private OpenIDConnectEndpoints fetchDefaultOidcEndpoints() throws IOException {
        if (this.getHost() == null) {
            return null;
        }
        if (this.getHostType() == HostType.UNIFIED) {
            return this.getUnifiedOidcEndpoints(this.getAccountId());
        }
        if (this.isAccountClient() && this.getAccountId() != null) {
            String prefix = this.getHost() + "/oidc/accounts/" + this.getAccountId();
            return new OpenIDConnectEndpoints(prefix + "/v1/token", prefix + "/v1/authorize");
        }
        ApiClient apiClient = new ApiClient.Builder().withHttpClient(this.getHttpClient()).withGetHostFunc(v -> this.getHost()).build();
        try {
            return apiClient.execute(new Request("GET", "/oidc/.well-known/oauth-authorization-server"), OpenIDConnectEndpoints.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    public String toString() {
        return ConfigLoader.debugString(this);
    }

    public DatabricksConfig setDatabricksEnvironment(DatabricksEnvironment databricksEnvironment) {
        this.databricksEnvironment = databricksEnvironment;
        return this;
    }

    public DatabricksEnvironment getDatabricksEnvironment() {
        ConfigLoader.fixHostIfNeeded(this);
        if (this.databricksEnvironment != null) {
            return this.databricksEnvironment;
        }
        if (this.host == null && this.azureWorkspaceResourceId != null) {
            String azureEnv = "PUBLIC";
            if (this.azureEnvironment != null) {
                azureEnv = this.azureEnvironment;
            }
            for (DatabricksEnvironment env : DatabricksEnvironment.ALL_ENVIRONMENTS) {
                if (env.getCloud() != Cloud.AZURE || !env.getAzureEnvironment().getName().equals(azureEnv) || env.getDnsZone().startsWith(".dev") || env.getDnsZone().startsWith(".staging")) continue;
                return env;
            }
        }
        return DatabricksEnvironment.getEnvironmentFromHostname(this.host);
    }

    private DatabricksConfig clone(Set<String> fieldsToSkip) {
        DatabricksConfig newConfig = new DatabricksConfig();
        for (Field f : DatabricksConfig.class.getDeclaredFields()) {
            if (fieldsToSkip.contains(f.getName())) continue;
            try {
                f.set(newConfig, f.get(this));
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return newConfig;
    }

    public DatabricksConfig clone() {
        return this.clone(new HashSet<String>());
    }

    public DatabricksConfig newWithWorkspaceHost(String host) {
        HashSet<String> fieldsToSkip = new HashSet<String>(Arrays.asList("host", "accountId", "azureWorkspaceResourceId", "headerFactory"));
        return this.clone(fieldsToSkip).setHost(host);
    }

    public String getEffectiveOAuthRedirectUrl() {
        return this.redirectUrl != null ? this.redirectUrl : "http://localhost:8080/callback";
    }
}

