/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.oauth;

import com.databricks.sdk.core.oauth.Token;
import com.databricks.sdk.core.oauth.TokenCache;
import com.databricks.sdk.core.utils.SerDeUtils;
import com.databricks.sdk.support.InternalApi;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalApi
public class FileTokenCache
implements TokenCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileTokenCache.class);
    private final Path cacheFile;
    private final ObjectMapper mapper;

    public FileTokenCache(Path cacheFilePath) {
        Objects.requireNonNull(cacheFilePath, "cacheFilePath must be defined");
        this.cacheFile = cacheFilePath;
        this.mapper = SerDeUtils.createMapper();
    }

    @Override
    public void save(Token token) {
        try {
            Files.createDirectories(this.cacheFile.getParent(), new FileAttribute[0]);
            String json = this.mapper.writeValueAsString((Object)token);
            byte[] dataToWrite = json.getBytes(StandardCharsets.UTF_8);
            Files.write(this.cacheFile, dataToWrite, new OpenOption[0]);
            File file = this.cacheFile.toFile();
            file.setReadable(false, false);
            file.setReadable(true, true);
            file.setWritable(false, false);
            file.setWritable(true, true);
            LOGGER.debug("Successfully saved token to cache: {}", (Object)this.cacheFile);
        }
        catch (Exception e) {
            LOGGER.warn("Failed to save token to cache: {}", (Object)this.cacheFile, (Object)e);
        }
    }

    @Override
    public Token load() {
        try {
            if (!Files.exists(this.cacheFile, new LinkOption[0])) {
                LOGGER.debug("No token cache file found at: {}", (Object)this.cacheFile);
                return null;
            }
            byte[] fileContent = Files.readAllBytes(this.cacheFile);
            String json = new String(fileContent, StandardCharsets.UTF_8);
            Token token = (Token)this.mapper.readValue(json, Token.class);
            LOGGER.debug("Successfully loaded token from cache: {}", (Object)this.cacheFile);
            return token;
        }
        catch (Exception e) {
            LOGGER.warn("Failed to load token from cache: {}", (Object)e.getMessage());
            return null;
        }
    }
}

