/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.core.retry;

import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.core.retry.IdempotentRequestRetryStrategy;
import com.databricks.sdk.core.retry.NonIdempotentRequestRetryStrategy;
import com.databricks.sdk.core.retry.RetryStrategy;
import com.databricks.sdk.core.retry.RetryStrategyPicker;
import com.databricks.sdk.support.InternalApi;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@InternalApi
public class RequestBasedRetryStrategyPicker
implements RetryStrategyPicker {
    private static final List<Request> IDEMPOTENT_REQUESTS = Arrays.asList(new Request("POST", "/api/2.0/sql/statements/sessions/"), new Request("POST", "/api/2.0/sql/sessions/"), new Request("DELETE", "/api/2.0/sql/statements/sessions/.*"), new Request("DELETE", "/api/2.0/sql/sessions/.*"), new Request("GET", "/api/2.0/sql/statements/.*"), new Request("DELETE", "/api/2.0/sql/statements/.*"), new Request("GET", "/api/2.0/sql/statements/.*/result/chunks/.*"));
    private final List<Map.Entry<String, Pattern>> idempotentRequestsPattern = IDEMPOTENT_REQUESTS.stream().map(request -> new AbstractMap.SimpleEntry<String, Pattern>(request.getMethod(), Pattern.compile(host + request.getUrl(), 2))).collect(Collectors.toList());
    private static final NonIdempotentRequestRetryStrategy NON_IDEMPOTENT_RETRY_STRATEGY = new NonIdempotentRequestRetryStrategy();
    private static final IdempotentRequestRetryStrategy IDEMPOTENT_RETRY_STRATEGY = new IdempotentRequestRetryStrategy();

    public RequestBasedRetryStrategyPicker(String host) {
    }

    @Override
    public RetryStrategy getRetryStrategy(Request request) {
        if (this.isIdempotentRequest(request)) {
            return IDEMPOTENT_RETRY_STRATEGY;
        }
        return NON_IDEMPOTENT_RETRY_STRATEGY;
    }

    private boolean isIdempotentRequest(Request request) {
        for (Map.Entry<String, Pattern> idempotentRequest : this.idempotentRequestsPattern) {
            if (!idempotentRequest.getKey().equals(request.getMethod()) || !idempotentRequest.getValue().matcher(request.getUrl()).find()) continue;
            return true;
        }
        return false;
    }
}

