/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.catalog;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.catalog.DeleteModelVersionRequest;
import com.databricks.sdk.service.catalog.GetByAliasRequest;
import com.databricks.sdk.service.catalog.GetModelVersionRequest;
import com.databricks.sdk.service.catalog.ListModelVersionsRequest;
import com.databricks.sdk.service.catalog.ListModelVersionsResponse;
import com.databricks.sdk.service.catalog.ModelVersionInfo;
import com.databricks.sdk.service.catalog.ModelVersionsService;
import com.databricks.sdk.service.catalog.UpdateModelVersionRequest;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ModelVersionsImpl
implements ModelVersionsService {
    private final ApiClient apiClient;

    public ModelVersionsImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public void delete(DeleteModelVersionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/versions/%s", request.getFullName(), request.getVersion());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ModelVersionInfo get(GetModelVersionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/versions/%s", request.getFullName(), request.getVersion());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ModelVersionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ModelVersionInfo getByAlias(GetByAliasRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/aliases/%s", request.getFullName(), request.getAlias());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ModelVersionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListModelVersionsResponse list(ListModelVersionsRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/versions", request.getFullName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListModelVersionsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ModelVersionInfo update(UpdateModelVersionRequest request) {
        String path = String.format("/api/2.1/unity-catalog/models/%s/versions/%s", request.getFullName(), request.getVersion());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ModelVersionInfo.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

