/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.compute;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.compute.ClusterPoliciesService;
import com.databricks.sdk.service.compute.ClusterPolicyPermissions;
import com.databricks.sdk.service.compute.ClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.CreatePolicy;
import com.databricks.sdk.service.compute.CreatePolicyResponse;
import com.databricks.sdk.service.compute.DeletePolicy;
import com.databricks.sdk.service.compute.EditPolicy;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionLevelsResponse;
import com.databricks.sdk.service.compute.GetClusterPolicyPermissionsRequest;
import com.databricks.sdk.service.compute.GetClusterPolicyRequest;
import com.databricks.sdk.service.compute.ListClusterPoliciesRequest;
import com.databricks.sdk.service.compute.ListPoliciesResponse;
import com.databricks.sdk.service.compute.Policy;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ClusterPoliciesImpl
implements ClusterPoliciesService {
    private final ApiClient apiClient;

    public ClusterPoliciesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreatePolicyResponse create(CreatePolicy request) {
        String path = "/api/2.0/policies/clusters/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, CreatePolicyResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeletePolicy request) {
        String path = "/api/2.0/policies/clusters/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void edit(EditPolicy request) {
        String path = "/api/2.0/policies/clusters/edit";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Policy get(GetClusterPolicyRequest request) {
        String path = "/api/2.0/policies/clusters/get";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, Policy.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetClusterPolicyPermissionLevelsResponse getPermissionLevels(GetClusterPolicyPermissionLevelsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s/permissionLevels", request.getClusterPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetClusterPolicyPermissionLevelsResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions getPermissions(GetClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPoliciesResponse list(ListClusterPoliciesRequest request) {
        String path = "/api/2.0/policies/clusters/list";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListPoliciesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions setPermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("PUT", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ClusterPolicyPermissions updatePermissions(ClusterPolicyPermissionsRequest request) {
        String path = String.format("/api/2.0/permissions/cluster-policies/%s", request.getClusterPolicyId());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ClusterPolicyPermissions.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

