/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.marketplace;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.marketplace.CreateFileRequest;
import com.databricks.sdk.service.marketplace.CreateFileResponse;
import com.databricks.sdk.service.marketplace.DeleteFileRequest;
import com.databricks.sdk.service.marketplace.GetFileRequest;
import com.databricks.sdk.service.marketplace.GetFileResponse;
import com.databricks.sdk.service.marketplace.ListFilesRequest;
import com.databricks.sdk.service.marketplace.ListFilesResponse;
import com.databricks.sdk.service.marketplace.ProviderFilesService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class ProviderFilesImpl
implements ProviderFilesService {
    private final ApiClient apiClient;

    public ProviderFilesImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateFileResponse create(CreateFileRequest request) {
        String path = "/api/2.0/marketplace-provider/files";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, CreateFileResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(DeleteFileRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/files/%s", request.getFileId());
        try {
            Request req = new Request("DELETE", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public GetFileResponse get(GetFileRequest request) {
        String path = String.format("/api/2.0/marketplace-provider/files/%s", request.getFileId());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, GetFileResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListFilesResponse list(ListFilesRequest request) {
        String path = "/api/2.0/marketplace-provider/files";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListFilesResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

