/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.networking;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.service.networking.CreateEndpointRequest;
import com.databricks.sdk.service.networking.DeleteEndpointRequest;
import com.databricks.sdk.service.networking.Endpoint;
import com.databricks.sdk.service.networking.EndpointsImpl;
import com.databricks.sdk.service.networking.EndpointsService;
import com.databricks.sdk.service.networking.GetEndpointRequest;
import com.databricks.sdk.service.networking.ListEndpointsRequest;
import com.databricks.sdk.service.networking.ListEndpointsResponse;
import com.databricks.sdk.support.Generated;
import com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class EndpointsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointsAPI.class);
    private final EndpointsService impl;

    public EndpointsAPI(ApiClient apiClient) {
        this.impl = new EndpointsImpl(apiClient);
    }

    public EndpointsAPI(EndpointsService mock) {
        this.impl = mock;
    }

    public Endpoint createEndpoint(CreateEndpointRequest request) {
        return this.impl.createEndpoint(request);
    }

    public void deleteEndpoint(String name) {
        this.deleteEndpoint(new DeleteEndpointRequest().setName(name));
    }

    public void deleteEndpoint(DeleteEndpointRequest request) {
        this.impl.deleteEndpoint(request);
    }

    public Endpoint getEndpoint(String name) {
        return this.getEndpoint(new GetEndpointRequest().setName(name));
    }

    public Endpoint getEndpoint(GetEndpointRequest request) {
        return this.impl.getEndpoint(request);
    }

    public Iterable<Endpoint> listEndpoints(String parent) {
        return this.listEndpoints(new ListEndpointsRequest().setParent(parent));
    }

    public Iterable<Endpoint> listEndpoints(ListEndpointsRequest request) {
        return new Paginator(request, this.impl::listEndpoints, ListEndpointsResponse::getItems, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public EndpointsService impl() {
        return this.impl;
    }
}

