/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settings;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settings.CreateTokenRequest;
import com.databricks.sdk.service.settings.CreateTokenResponse;
import com.databricks.sdk.service.settings.ListPublicTokensResponse;
import com.databricks.sdk.service.settings.RevokeTokenRequest;
import com.databricks.sdk.service.settings.TokensService;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class TokensImpl
implements TokensService {
    private final ApiClient apiClient;

    public TokensImpl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public CreateTokenResponse create(CreateTokenRequest request) {
        String path = "/api/2.0/token/create";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, CreateTokenResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public void delete(RevokeTokenRequest request) {
        String path = "/api/2.0/token/delete";
        try {
            Request req = new Request("POST", path, this.apiClient.serialize(request));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            this.apiClient.execute(req, Void.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListPublicTokensResponse list() {
        String path = "/api/2.0/token/list";
        try {
            Request req = new Request("GET", path);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListPublicTokensResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

