/*
 * Decompiled with CFR 0.152.
 */
package com.databricks.sdk.service.settingsv2;

import com.databricks.sdk.core.ApiClient;
import com.databricks.sdk.core.DatabricksException;
import com.databricks.sdk.core.http.Request;
import com.databricks.sdk.service.settingsv2.GetPublicWorkspaceSettingRequest;
import com.databricks.sdk.service.settingsv2.ListWorkspaceSettingsMetadataRequest;
import com.databricks.sdk.service.settingsv2.ListWorkspaceSettingsMetadataResponse;
import com.databricks.sdk.service.settingsv2.PatchPublicWorkspaceSettingRequest;
import com.databricks.sdk.service.settingsv2.Setting;
import com.databricks.sdk.service.settingsv2.WorkspaceSettingsV2Service;
import com.databricks.sdk.support.Generated;
import java.io.IOException;

@Generated
class WorkspaceSettingsV2Impl
implements WorkspaceSettingsV2Service {
    private final ApiClient apiClient;

    public WorkspaceSettingsV2Impl(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public Setting getPublicWorkspaceSetting(GetPublicWorkspaceSettingRequest request) {
        String path = String.format("/api/2.1/settings/%s", request.getName());
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, Setting.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public ListWorkspaceSettingsMetadataResponse listWorkspaceSettingsMetadata(ListWorkspaceSettingsMetadataRequest request) {
        String path = "/api/2.1/settings-metadata";
        try {
            Request req = new Request("GET", path);
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, ListWorkspaceSettingsMetadataResponse.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }

    @Override
    public Setting patchPublicWorkspaceSetting(PatchPublicWorkspaceSettingRequest request) {
        String path = String.format("/api/2.1/settings/%s", request.getName());
        try {
            Request req = new Request("PATCH", path, this.apiClient.serialize(request.getSetting()));
            ApiClient.setQuery(req, request);
            req.withHeader("Accept", "application/json");
            req.withHeader("Content-Type", "application/json");
            if (this.apiClient.workspaceId() != null) {
                req.withHeader("X-Databricks-Org-Id", this.apiClient.workspaceId());
            }
            return this.apiClient.execute(req, Setting.class);
        }
        catch (IOException e) {
            throw new DatabricksException("IO error: " + e.getMessage(), e);
        }
    }
}

