/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2ProxyRequestEvent;
import com.datadoghq.datadog_lambda_java.CustomMetric;
import com.datadoghq.datadog_lambda_java.DDLogger;
import com.datadoghq.datadog_lambda_java.EnhancedMetric;
import com.datadoghq.datadog_lambda_java.Headerable;
import com.datadoghq.datadog_lambda_java.Tracing;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Map;
import okhttp3.Request;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class DDLambda {
    private String ENHANCED_ENV = "DD_ENHANCED_METRICS";
    private String ENHANCED_PREFIX = "aws.lambda.enhanced.";
    private String INVOCATION = "invocations";
    private String ERROR = "errors";
    private Tracing tracing;
    private boolean enhanced = true;

    public DDLambda(Context cxt) {
        this.tracing = new Tracing();
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
    }

    public DDLambda(APIGatewayProxyRequestEvent req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
    }

    public DDLambda(APIGatewayV2ProxyRequestEvent req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
    }

    public DDLambda(Headerable req, Context cxt) {
        this.enhanced = this.checkEnhanced();
        this.recordEnhanced(this.INVOCATION, cxt);
        this.tracing = new Tracing(req);
        this.tracing.submitSegment();
    }

    private boolean checkEnhanced() {
        String sysEnhanced = System.getenv(this.ENHANCED_ENV);
        if (sysEnhanced == null) {
            return true;
        }
        return sysEnhanced.toLowerCase() != "false";
    }

    public void metric(String name, double value, Map<String, Object> tags) {
        new CustomMetric(name, value, tags).write();
    }

    public void metric(String name, double value, Map<String, Object> tags, Date date) {
        new CustomMetric(name, value, tags, date).write();
    }

    public void error(Context cxt) {
        this.recordEnhanced(this.ERROR, cxt);
    }

    private void recordEnhanced(String basename, Context cxt) {
        String metricName = basename;
        Map<String, Object> tags = null;
        if (this.enhanced) {
            metricName = this.ENHANCED_PREFIX + basename;
            tags = EnhancedMetric.makeTagsFromContext(cxt);
        }
        new CustomMetric(metricName, 1.0, tags).write();
    }

    public URLConnection makeUrlConnection(URL url) throws IOException {
        URLConnection uc = url.openConnection();
        return this.addTraceHeaders(uc);
    }

    public URLConnection addTraceHeaders(URLConnection urlConnection) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return urlConnection;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach(urlConnection::setRequestProperty);
        return urlConnection;
    }

    public HttpGet makeHttpGet(String url) {
        HttpGet hg = new HttpGet(url);
        hg = (HttpGet)this.addTraceHeaders((HttpUriRequest)hg);
        return hg;
    }

    public HttpUriRequest addTraceHeaders(HttpUriRequest httpRequest) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return httpRequest;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach((arg_0, arg_1) -> ((HttpUriRequest)httpRequest).setHeader(arg_0, arg_1));
        return httpRequest;
    }

    public Request.Builder makeRequestBuilder() {
        Request.Builder hrb = new Request.Builder();
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        traceHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)hrb).addHeader(arg_0, arg_1));
        return hrb;
    }

    public Request addTraceHeaders(Request request) {
        if (this.tracing == null) {
            DDLogger.getLoggerImpl().error("Unable to add trace headers from an untraceable request. Did you pass LambdaInstrumenter a request?", new Object[0]);
            return request;
        }
        Map<String, String> traceHeaders = this.tracing.makeOutboundHttpTraceHeaders();
        Request.Builder rb = request.newBuilder();
        traceHeaders.forEach((arg_0, arg_1) -> ((Request.Builder)rb).addHeader(arg_0, arg_1));
        return rb.build();
    }
}

