/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.DDLogger;
import java.util.HashMap;
import java.util.Map;

class XRayTraceContext {
    String traceIdHeader;
    String traceId;
    String parentId;

    public XRayTraceContext() {
        String traceId = System.getenv("_X_AMZN_TRACE_ID");
        if (traceId == null) {
            DDLogger.getLoggerImpl().debug("Unable to find _X_AMZN_TRACE_ID", new Object[0]);
            return;
        }
        String[] traceParts = traceId.split(";");
        if (traceParts.length != 3) {
            DDLogger.getLoggerImpl().error("Malformed _X_AMZN_TRACE_ID value: " + traceId, new Object[0]);
            return;
        }
        try {
            this.traceId = traceParts[0].split("=")[1];
            this.parentId = traceParts[1].split("=")[1];
        }
        catch (Exception e) {
            DDLogger.getLoggerImpl().error("Malformed _X_AMZN_TRACE_ID value: " + traceId, new Object[0]);
            return;
        }
        this.traceIdHeader = traceId;
    }

    public void setTraceIdHeader(String traceIdHeader) {
        this.traceIdHeader = traceIdHeader;
    }

    public void setTraceId(String traceId) {
        this.traceId = traceId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getParentId() {
        return this.parentId;
    }

    public Map<String, String> getKeyValues() {
        HashMap<String, String> keyValues = new HashMap<String, String>();
        if (this.traceIdHeader != null) {
            keyValues.put("X-Amzn-Trace-Id", this.traceIdHeader);
        }
        return keyValues;
    }

    public String getAPMParentID() {
        try {
            String lastSixteen = this.parentId.substring(this.parentId.length() - 16);
            Long l_ApmId = Long.parseUnsignedLong(lastSixteen, 16);
            return Long.toUnsignedString(l_ApmId);
        }
        catch (Exception e) {
            DDLogger.getLoggerImpl().debug("Problem converting XRay Parent ID to APM Parent ID: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

