/*
 * Decompiled with CFR 0.152.
 */
package com.datadoghq.datadog_lambda_java;

import com.datadoghq.datadog_lambda_java.DDLogger;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

class Extension {
    private static final String AGENT_URL = "http://127.0.0.1:8124";
    private static final String HELLO_PATH = "/lambda/hello";
    private static final String FLUSH_PATH = "/lambda/flush";
    private static final String EXTENSION_PATH = "/opt/extensions/datadog-agent";

    Extension() {
    }

    protected static boolean setup() {
        boolean shouldUseExtension = false;
        if (Extension.isExtensionRunning(EXTENSION_PATH)) {
            DDLogger.getLoggerImpl().debug("Extension has been detected", new Object[0]);
            if (Extension.hitHelloRoute(AGENT_URL, HELLO_PATH)) {
                shouldUseExtension = true;
            } else {
                DDLogger.getLoggerImpl().debug("Could not call the hello route", new Object[0]);
            }
        }
        return shouldUseExtension;
    }

    protected static void flush() {
        if (!Extension.hitFlushRoute(AGENT_URL, FLUSH_PATH)) {
            DDLogger.getLoggerImpl().debug("Could not call the flush route", new Object[0]);
        }
    }

    protected static boolean isExtensionRunning(String extensionPath) {
        File f = new File(extensionPath);
        return f.exists() && !f.isDirectory();
    }

    protected static boolean hitHelloRoute(String agentUrl, String helloPath) {
        try {
            URL url = new URL(agentUrl + helloPath);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            return http.getResponseCode() == 200;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected static boolean hitFlushRoute(String agentUrl, String flushPath) {
        try {
            URL url = new URL(agentUrl + flushPath);
            HttpURLConnection http = (HttpURLConnection)url.openConnection();
            http.setRequestMethod("POST");
            return http.getResponseCode() == 200;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }
}

