/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.slf4j.Logger;
import datadog.slf4j.LoggerFactory;
import datadog.trace.api.Platform;
import datadog.trace.bootstrap.Library;
import datadog.trace.util.AgentTaskScheduler;
import datadog.trace.util.AgentThreadFactory;
import datadog.trace.util.Strings;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.EnumSet;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class Agent {
    private static final String SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY = "datadog.slf4j.simpleLogger.showDateTime";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY = "datadog.slf4j.simpleLogger.dateTimeFormat";
    private static final String SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT = "'[dd.trace 'yyyy-MM-dd HH:mm:ss:SSS Z']'";
    private static final String SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY = "datadog.slf4j.simpleLogger.defaultLogLevel";
    private static final int DEFAULT_JMX_FETCH_START_DELAY = 15;
    private static final Logger log;
    private static final AtomicBoolean jmxStarting;
    private static ClassLoader PARENT_CLASSLOADER;
    private static ClassLoader BOOTSTRAP_PROXY;
    private static ClassLoader AGENT_CLASSLOADER;
    private static ClassLoader JMXFETCH_CLASSLOADER;
    private static ClassLoader PROFILING_CLASSLOADER;

    public static void start(Instrumentation inst, URL bootstrapURL) {
        Agent.createParentClassloader(bootstrapURL);
        Agent.startProfilingAgent(bootstrapURL, true);
        Agent.startDatadogAgent(inst, bootstrapURL);
        EnumSet<Library> libraries = Library.detectLibraries(log);
        boolean appUsingCustomLogManager = Agent.isAppUsingCustomLogManager(libraries);
        boolean appUsingCustomJMXBuilder = Agent.isAppUsingCustomJMXBuilder(libraries);
        int jmxStartDelay = Agent.getJmxStartDelay();
        if (appUsingCustomJMXBuilder) {
            log.debug("Custom JMX builder detected. Delaying JMXFetch initialization.");
            Agent.registerMBeanServerBuilderCallback(new StartJmxCallback(bootstrapURL, jmxStartDelay));
            Agent.scheduleJmxStart(bootstrapURL, 60 + jmxStartDelay);
        } else if (appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying JMXFetch initialization.");
            Agent.registerLogManagerCallback(new StartJmxCallback(bootstrapURL, jmxStartDelay));
        } else {
            Agent.scheduleJmxStart(bootstrapURL, jmxStartDelay);
        }
        if (Agent.isJavaBefore9WithJFR() && appUsingCustomLogManager) {
            log.debug("Custom logger detected. Delaying Datadog Tracer initialization.");
            Agent.registerLogManagerCallback(new InstallDatadogTracerCallback(bootstrapURL));
        } else {
            Agent.installDatadogTracer();
        }
        boolean shouldDelayProfilerStartup = false;
        if (!Platform.isJavaVersionAtLeast(9)) {
            if (appUsingCustomLogManager) {
                log.debug("Custom logger detected. Delaying Profiling Agent startup.");
                shouldDelayProfilerStartup = true;
            }
            if (System.getProperty("java.vendor").contains("Oracle") && !System.getProperty("java.runtime.name").contains("OpenJDK")) {
                log.debug("Oracle JDK 8 detected. Delaying Profiling Agent startup");
                shouldDelayProfilerStartup = true;
            }
        }
        if (shouldDelayProfilerStartup) {
            Agent.registerLogManagerCallback(new StartProfilingAgentCallback(inst, bootstrapURL));
        } else {
            Agent.startProfilingAgent(bootstrapURL, false);
        }
    }

    private static void registerLogManagerCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentInstaller");
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "java.util.logging.LogManager", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static void registerMBeanServerBuilderCallback(ClassLoadCallBack callback) {
        try {
            Class<?> agentInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.AgentInstaller");
            Method registerCallbackMethod = agentInstallerClass.getMethod("registerClassLoadCallback", String.class, Runnable.class);
            registerCallbackMethod.invoke(null, "javax.management.MBeanServerBuilder", callback);
        }
        catch (Exception ex) {
            log.error("Error registering callback for {}", (Object)callback.agentThread(), (Object)ex);
        }
    }

    private static synchronized void createParentClassloader(URL bootstrapURL) {
        if (PARENT_CLASSLOADER == null) {
            try {
                Class<?> bootstrapProxyClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$BootstrapClassLoaderProxy");
                Constructor<?> constructor = bootstrapProxyClass.getDeclaredConstructor(URL.class);
                BOOTSTRAP_PROXY = (ClassLoader)constructor.newInstance(bootstrapURL);
                ClassLoader grandParent = !Platform.isJavaVersionAtLeast(9) ? null : Agent.getPlatformClassLoader();
                PARENT_CLASSLOADER = Agent.createDatadogClassLoader("shared", bootstrapURL, grandParent);
            }
            catch (Throwable ex) {
                log.error("Throwable thrown creating parent classloader", ex);
            }
        }
    }

    private static synchronized void startDatadogAgent(Instrumentation inst, URL bootstrapURL) {
        if (AGENT_CLASSLOADER == null) {
            try {
                ClassLoader agentClassLoader = Agent.createDelegateClassLoader("inst", bootstrapURL, PARENT_CLASSLOADER);
                Class<?> agentInstallerClass = agentClassLoader.loadClass("datadog.trace.agent.tooling.AgentInstaller");
                Method agentInstallerMethod = agentInstallerClass.getMethod("installBytebuddyAgent", Instrumentation.class);
                agentInstallerMethod.invoke(null, inst);
                AGENT_CLASSLOADER = agentClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while installing the Datadog Agent", ex);
            }
        }
    }

    private static synchronized void installDatadogTracer() {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        try {
            Class<?> tracerInstallerClass = AGENT_CLASSLOADER.loadClass("datadog.trace.agent.tooling.TracerInstaller");
            Method tracerInstallerMethod = tracerInstallerClass.getMethod("installGlobalTracer", new Class[0]);
            tracerInstallerMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while installing the Datadog Tracer", ex);
        }
    }

    private static void scheduleJmxStart(URL bootstrapURL, int jmxStartDelay) {
        if (jmxStartDelay > 0) {
            AgentTaskScheduler.INSTANCE.scheduleWithJitter(new JmxStartTask(), bootstrapURL, jmxStartDelay, TimeUnit.SECONDS);
        } else {
            Agent.startJmx(bootstrapURL);
        }
    }

    private static synchronized void startJmx(URL bootstrapURL) {
        if (AGENT_CLASSLOADER == null) {
            throw new IllegalStateException("Datadog agent should have been started already");
        }
        if (jmxStarting.getAndSet(true)) {
            return;
        }
        Agent.startJmxFetch(bootstrapURL);
        Agent.initializeJmxSystemAccessProvider(AGENT_CLASSLOADER);
        Agent.registerDeadlockDetectionEvent(bootstrapURL);
    }

    private static synchronized void registerDeadlockDetectionEvent(URL bootstrapUrl) {
        log.debug("Initializing JMX thread deadlock detector");
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapUrl);
            Class<?> deadlockFactoryClass = classLoader.loadClass("com.datadog.profiling.controller.openjdk.events.DeadlockEventFactory");
            Method registerMethod = deadlockFactoryClass.getMethod("registerEvents", new Class[0]);
            registerMethod.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | NoClassDefFoundError | UnsupportedClassVersionError ignored) {
            log.debug("JMX deadlock detection not supported");
        }
        catch (Throwable ex) {
            log.error("Unable to initialize JMX thread deadlock detector", ex);
        }
    }

    private static synchronized void initializeJmxSystemAccessProvider(ClassLoader classLoader) {
        log.debug("Initializing JMX system access provider for " + classLoader.toString());
        try {
            Class<?> tracerInstallerClass = classLoader.loadClass("datadog.trace.agent.core.util.SystemAccess");
            Method enableJmxMethod = tracerInstallerClass.getMethod("enableJmx", new Class[0]);
            enableJmxMethod.invoke(null, new Object[0]);
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while initializing JMX system access provider", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startJmxFetch(URL bootstrapURL) {
        if (JMXFETCH_CLASSLOADER == null) {
            ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader jmxFetchClassLoader = Agent.createDelegateClassLoader("metrics", bootstrapURL, PARENT_CLASSLOADER);
                Thread.currentThread().setContextClassLoader(jmxFetchClassLoader);
                Class<?> jmxFetchAgentClass = jmxFetchClassLoader.loadClass("datadog.trace.agent.jmxfetch.JMXFetch");
                Method jmxFetchInstallerMethod = jmxFetchAgentClass.getMethod("run", new Class[0]);
                jmxFetchInstallerMethod.invoke(null, new Object[0]);
                JMXFETCH_CLASSLOADER = jmxFetchClassLoader;
            }
            catch (Throwable ex) {
                log.error("Throwable thrown while starting JmxFetch", ex);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextLoader);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void startProfilingAgent(URL bootstrapURL, boolean isStartingFirst) {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader classLoader = Agent.getProfilingClassloader(bootstrapURL);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> profilingAgentClass = classLoader.loadClass("com.datadog.profiling.agent.ProfilingAgent");
            Method profilingInstallerMethod = profilingAgentClass.getMethod("run", Boolean.TYPE);
            profilingInstallerMethod.invoke(null, isStartingFirst);
        }
        catch (ClassFormatError e) {
            log.debug("Profiling requires OpenJDK 8 or above - skipping");
        }
        catch (Throwable ex) {
            log.error("Throwable thrown while starting profiling agent", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextLoader);
        }
    }

    private static synchronized ClassLoader getProfilingClassloader(URL bootstrapURL) throws Exception {
        if (PROFILING_CLASSLOADER == null) {
            PROFILING_CLASSLOADER = Agent.createDelegateClassLoader("profiling", bootstrapURL, PARENT_CLASSLOADER);
        }
        return PROFILING_CLASSLOADER;
    }

    private static void configureLogger() {
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_SHOW_DATE_TIME_PROPERTY, "true");
        Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DATE_TIME_FORMAT_PROPERTY, SIMPLE_LOGGER_DATE_TIME_FORMAT_DEFAULT);
        if (Agent.isDebugMode()) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "DEBUG");
        } else if (!Agent.isStartupLogsEnabled()) {
            Agent.setSystemPropertyDefault(SIMPLE_LOGGER_DEFAULT_LOG_LEVEL_PROPERTY, "WARN");
        }
    }

    private static void setSystemPropertyDefault(String property, String value) {
        if (System.getProperty(property) == null) {
            System.setProperty(property, value);
        }
    }

    private static ClassLoader createDatadogClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class);
        return (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent);
    }

    private static ClassLoader createDelegateClassLoader(String innerJarFilename, URL bootstrapURL, ClassLoader parent) throws Exception {
        Class<?> loaderClass = ClassLoader.getSystemClassLoader().loadClass("datadog.trace.bootstrap.DatadogClassLoader$DelegateClassLoader");
        Constructor<?> constructor = loaderClass.getDeclaredConstructor(URL.class, String.class, ClassLoader.class, ClassLoader.class, ClassLoader.class);
        ClassLoader classLoader = (ClassLoader)constructor.newInstance(bootstrapURL, innerJarFilename, BOOTSTRAP_PROXY, parent, PARENT_CLASSLOADER);
        return classLoader;
    }

    private static ClassLoader getPlatformClassLoader() throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Method method = ClassLoader.class.getDeclaredMethod("getPlatformClassLoader", new Class[0]);
        return (ClassLoader)method.invoke(null, new Object[0]);
    }

    private static boolean isDebugMode() {
        String tracerDebugLevelSysprop = "dd.trace.debug";
        String tracerDebugLevelProp = System.getProperty("dd.trace.debug");
        if (tracerDebugLevelProp != null) {
            return Boolean.parseBoolean(tracerDebugLevelProp);
        }
        String tracerDebugLevelEnv = Agent.ddGetEnv("dd.trace.debug");
        if (tracerDebugLevelEnv != null) {
            return Boolean.parseBoolean(tracerDebugLevelEnv);
        }
        return false;
    }

    private static boolean isStartupLogsEnabled() {
        String startupLogsSysprop = "dd.trace.startup.logs";
        String startupLogsEnabled = System.getProperty("dd.trace.startup.logs");
        if (startupLogsEnabled == null) {
            startupLogsEnabled = Agent.ddGetEnv("dd.trace.startup.logs");
        }
        return !"false".equalsIgnoreCase(startupLogsEnabled);
    }

    private static int getJmxStartDelay() {
        String jmxStartDelaySysprop = "dd.jmxfetch.start-delay";
        String jmxStartDelay = System.getProperty("dd.jmxfetch.start-delay");
        if (jmxStartDelay == null) {
            jmxStartDelay = Agent.ddGetEnv("dd.jmxfetch.start-delay");
        }
        if (jmxStartDelay != null) {
            try {
                return Integer.parseInt(jmxStartDelay);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 15;
    }

    private static boolean isAppUsingCustomLogManager(EnumSet<Library> libraries) {
        String tracerCustomLogManSysprop = "dd.app.customlogmanager";
        String customLogManagerProp = System.getProperty("dd.app.customlogmanager");
        String customLogManagerEnv = Agent.ddGetEnv("dd.app.customlogmanager");
        if (customLogManagerProp != null || customLogManagerEnv != null) {
            log.debug("Prop - customlogmanager: {}", (Object)customLogManagerProp);
            log.debug("Env - customlogmanager: {}", (Object)customLogManagerEnv);
            return Boolean.parseBoolean(customLogManagerProp) || Boolean.parseBoolean(customLogManagerEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String logManagerProp = System.getProperty("java.util.logging.manager");
        if (logManagerProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(logManagerProp)) != null;
            log.debug("Prop - logging.manager: {}", (Object)logManagerProp);
            log.debug("logging.manager on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static boolean isAppUsingCustomJMXBuilder(EnumSet<Library> libraries) {
        String tracerCustomJMXBuilderSysprop = "dd.app.customjmxbuilder";
        String customJMXBuilderProp = System.getProperty("dd.app.customjmxbuilder");
        String customJMXBuilderEnv = Agent.ddGetEnv("dd.app.customjmxbuilder");
        if (customJMXBuilderProp != null || customJMXBuilderEnv != null) {
            log.debug("Prop - customjmxbuilder: {}", (Object)customJMXBuilderProp);
            log.debug("Env - customjmxbuilder: {}", (Object)customJMXBuilderEnv);
            return Boolean.parseBoolean(customJMXBuilderProp) || Boolean.parseBoolean(customJMXBuilderEnv);
        }
        if (libraries.contains((Object)Library.WILDFLY)) {
            return true;
        }
        String jmxBuilderProp = System.getProperty("javax.management.builder.initial");
        if (jmxBuilderProp != null) {
            boolean onSysClasspath = ClassLoader.getSystemResource(Strings.getResourceName(jmxBuilderProp)) != null;
            log.debug("Prop - javax.management.builder.initial: {}", (Object)jmxBuilderProp);
            log.debug("javax.management.builder.initial on system classpath: {}", (Object)onSysClasspath);
            return !onSysClasspath;
        }
        return false;
    }

    private static String ddGetEnv(String sysProp) {
        return System.getenv(Strings.toEnvVar(sysProp));
    }

    private static boolean isJavaBefore9WithJFR() {
        if (Platform.isJavaVersionAtLeast(9)) {
            return false;
        }
        return Thread.currentThread().getContextClassLoader().getResource("jdk/jfr/Recording.class") != null;
    }

    static {
        Agent.configureLogger();
        log = LoggerFactory.getLogger(Agent.class);
        jmxStarting = new AtomicBoolean();
        PARENT_CLASSLOADER = null;
        BOOTSTRAP_PROXY = null;
        AGENT_CLASSLOADER = null;
        JMXFETCH_CLASSLOADER = null;
        PROFILING_CLASSLOADER = null;
    }

    static final class JmxStartTask
    implements AgentTaskScheduler.Task<URL> {
        JmxStartTask() {
        }

        @Override
        public void run(URL bootstrapURL) {
            Agent.startJmx(bootstrapURL);
        }
    }

    protected static class StartProfilingAgentCallback
    extends ClassLoadCallBack {
        StartProfilingAgentCallback(Instrumentation inst, URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.PROFILER_STARTUP;
        }

        @Override
        public void execute() {
            Agent.startProfilingAgent(this.bootstrapURL, false);
        }
    }

    protected static class InstallDatadogTracerCallback
    extends ClassLoadCallBack {
        InstallDatadogTracerCallback(URL bootstrapURL) {
            super(bootstrapURL);
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.TRACE_STARTUP;
        }

        @Override
        public void execute() {
            Agent.installDatadogTracer();
        }
    }

    protected static class StartJmxCallback
    extends ClassLoadCallBack {
        private final int jmxStartDelay;

        StartJmxCallback(URL bootstrapURL, int jmxStartDelay) {
            super(bootstrapURL);
            this.jmxStartDelay = jmxStartDelay;
        }

        @Override
        public AgentThreadFactory.AgentThread agentThread() {
            return AgentThreadFactory.AgentThread.JMX_STARTUP;
        }

        @Override
        public void execute() {
            ManagementFactory.getPlatformMBeanServer();
            Agent.scheduleJmxStart(this.bootstrapURL, this.jmxStartDelay);
        }
    }

    protected static abstract class ClassLoadCallBack
    implements Runnable {
        final URL bootstrapURL;

        ClassLoadCallBack(URL bootstrapURL) {
            this.bootstrapURL = bootstrapURL;
        }

        @Override
        public void run() {
            Thread thread = AgentThreadFactory.newAgentThread(this.agentThread(), new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassLoadCallBack.this.execute();
                    }
                    catch (Exception e) {
                        log.error("Failed to run {}", (Object)ClassLoadCallBack.this.agentThread(), (Object)e);
                    }
                }
            });
            thread.start();
        }

        public abstract AgentThreadFactory.AgentThread agentThread();

        public abstract void execute();
    }
}

