/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap;

import datadog.trace.api.Function;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public interface WeakMap<K, V> {
    public int size();

    public boolean containsKey(K var1);

    public V get(K var1);

    public void put(K var1, V var2);

    public void putIfAbsent(K var1, V var2);

    public V computeIfAbsent(K var1, Function<? super K, ? extends V> var2);

    public static interface Implementation {
        public <K, V> WeakMap<K, V> get();
    }

    public static class Provider {
        private static final AtomicReferenceFieldUpdater<Provider, Implementation> UPDATER = AtomicReferenceFieldUpdater.newUpdater(Provider.class, Implementation.class, "provider");
        private volatile Implementation provider = null;
        private static final Provider INSTANCE = new Provider();

        public static void registerIfAbsent(Implementation provider) {
            UPDATER.compareAndSet(INSTANCE, null, provider);
        }

        public static <K, V> WeakMap<K, V> newWeakMap() {
            return Provider.INSTANCE.provider.get();
        }
    }
}

