/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;

class GithubActionsInfo
extends CIProviderInfo {
    public static final String GHACTIONS = "GITHUB_ACTION";
    public static final String GHACTIONS_PROVIDER_NAME = "github";
    public static final String GHACTIONS_PIPELINE_ID = "GITHUB_RUN_ID";
    public static final String GHACTIONS_PIPELINE_NAME = "GITHUB_WORKFLOW";
    public static final String GHACTIONS_PIPELINE_NUMBER = "GITHUB_RUN_NUMBER";
    public static final String GHACTIONS_WORKSPACE_PATH = "GITHUB_WORKSPACE";
    public static final String GHACTIONS_REPOSITORY = "GITHUB_REPOSITORY";
    public static final String GHACTIONS_SHA = "GITHUB_SHA";
    public static final String GHACTIONS_HEAD_REF = "GITHUB_HEAD_REF";
    public static final String GHACTIONS_REF = "GITHUB_REF";

    GithubActionsInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        return new GitInfo(this.buildGitRepositoryUrl(System.getenv(GHACTIONS_REPOSITORY)), this.buildGitBranch(), this.buildGitTag(), new CommitInfo(System.getenv(GHACTIONS_SHA)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        String url = this.buildPipelineUrl(System.getenv(GHACTIONS_REPOSITORY), System.getenv(GHACTIONS_SHA));
        return CIProviderInfo.CIInfo.builder().ciProviderName(GHACTIONS_PROVIDER_NAME).ciPipelineId(System.getenv(GHACTIONS_PIPELINE_ID)).ciPipelineName(System.getenv(GHACTIONS_PIPELINE_NAME)).ciPipelineNumber(System.getenv(GHACTIONS_PIPELINE_NUMBER)).ciPipelineUrl(url).ciJobUrl(url).ciWorkspace(this.expandTilde(System.getenv(GHACTIONS_WORKSPACE_PATH))).build();
    }

    private String buildGitTag() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitBranch() {
        String gitBranchOrTag = System.getenv(GHACTIONS_HEAD_REF);
        if (gitBranchOrTag == null || gitBranchOrTag.isEmpty()) {
            gitBranchOrTag = System.getenv(GHACTIONS_REF);
        }
        if (gitBranchOrTag != null && !gitBranchOrTag.contains("tags")) {
            return this.normalizeRef(gitBranchOrTag);
        }
        return null;
    }

    private String buildGitRepositoryUrl(String repo) {
        if (repo == null || repo.isEmpty()) {
            return null;
        }
        return String.format("https://github.com/%s.git", repo);
    }

    private String buildPipelineUrl(String repo, String commit) {
        return String.format("https://github.com/%s/commit/%s/checks", repo, commit);
    }
}

