/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci;

import datadog.trace.bootstrap.instrumentation.ci.CIProviderInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.CommitInfo;
import datadog.trace.bootstrap.instrumentation.ci.git.GitInfo;

class TravisInfo
extends CIProviderInfo {
    public static final String TRAVIS = "TRAVIS";
    public static final String TRAVIS_PROVIDER_NAME = "travisci";
    public static final String TRAVIS_PIPELINE_ID = "TRAVIS_BUILD_ID";
    public static final String TRAVIS_PIPELINE_NUMBER = "TRAVIS_BUILD_NUMBER";
    public static final String TRAVIS_PIPELINE_URL = "TRAVIS_BUILD_WEB_URL";
    public static final String TRAVIS_JOB_URL = "TRAVIS_JOB_WEB_URL";
    public static final String TRAVIS_WORKSPACE_PATH = "TRAVIS_BUILD_DIR";
    public static final String TRAVIS_REPOSITORY_SLUG = "TRAVIS_REPO_SLUG";
    public static final String TRAVIS_PR_REPOSITORY_SLUG = "TRAVIS_PULL_REQUEST_SLUG";
    public static final String TRAVIS_GIT_COMMIT = "TRAVIS_COMMIT";
    public static final String TRAVIS_GIT_PR_BRANCH = "TRAVIS_PULL_REQUEST_BRANCH";
    public static final String TRAVIS_GIT_BRANCH = "TRAVIS_BRANCH";
    public static final String TRAVIS_GIT_TAG = "TRAVIS_TAG";

    TravisInfo() {
    }

    @Override
    protected GitInfo buildCIGitInfo() {
        String gitTag = this.normalizeRef(System.getenv(TRAVIS_GIT_TAG));
        return new GitInfo(this.buildGitRepositoryUrl(), this.buildGitBranch(gitTag), gitTag, new CommitInfo(System.getenv(TRAVIS_GIT_COMMIT)));
    }

    @Override
    protected CIProviderInfo.CIInfo buildCIInfo() {
        return CIProviderInfo.CIInfo.builder().ciProviderName(TRAVIS_PROVIDER_NAME).ciPipelineId(System.getenv(TRAVIS_PIPELINE_ID)).ciPipelineName(this.buildCiPipelineName()).ciPipelineNumber(System.getenv(TRAVIS_PIPELINE_NUMBER)).ciPipelineUrl(System.getenv(TRAVIS_PIPELINE_URL)).ciJobUrl(System.getenv(TRAVIS_JOB_URL)).ciWorkspace(this.expandTilde(System.getenv(TRAVIS_WORKSPACE_PATH))).build();
    }

    private String buildGitBranch(String gitTag) {
        if (gitTag != null) {
            return null;
        }
        String fromBranch = System.getenv(TRAVIS_GIT_PR_BRANCH);
        if (fromBranch != null && !fromBranch.isEmpty()) {
            return this.normalizeRef(fromBranch);
        }
        return this.normalizeRef(System.getenv(TRAVIS_GIT_BRANCH));
    }

    private String buildGitRepositoryUrl() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        if (repoSlug == null || repoSlug.isEmpty()) {
            return null;
        }
        return String.format("https://github.com/%s.git", repoSlug);
    }

    private String buildCiPipelineName() {
        String repoSlug = System.getenv(TRAVIS_PR_REPOSITORY_SLUG);
        if (repoSlug == null || repoSlug.isEmpty()) {
            repoSlug = System.getenv(TRAVIS_REPOSITORY_SLUG);
        }
        return repoSlug;
    }
}

