/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.bootstrap.instrumentation.ci.git;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;

public class PersonInfo {
    public static final PersonInfo NOOP = new PersonInfo();
    private static final String DATE_FORMAT_ISO8601 = "yyyy-MM-dd'T'HH:mm:ss.SSSXXX";
    private final String name;
    private final String email;
    private final long when;
    private final int tzOffset;

    public PersonInfo() {
        this(null, null, 0L, 0);
    }

    public PersonInfo(String name, String email, long when, int tzOffset) {
        this.name = name;
        this.email = email;
        this.when = when;
        this.tzOffset = tzOffset;
    }

    public String getISO8601Date() {
        if (this.when <= 0L) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_ISO8601);
        sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
        return sdf.format(new Date(this.when));
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public long getWhen() {
        return this.when;
    }

    public int getTzOffset() {
        return this.tzOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersonInfo that = (PersonInfo)o;
        return this.when == that.when && this.tzOffset == that.tzOffset && Objects.equals(this.name, that.name) && Objects.equals(this.email, that.email);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.email, this.when, this.tzOffset);
    }

    public String toString() {
        return "PersonInfo{name='" + this.name + '\'' + ", email='" + this.email + '\'' + ", when=" + this.when + ", tzOffset=" + this.tzOffset + '}';
    }
}

