/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class DynamoDB
extends BaseConnector<DynamoDB> {
    public DynamoDB() {
        super(OutputType.DYNAMO_DB);
        this.setup(this, "table", "auth.access_key", "auth.secret_key", "region");
    }

    public DynamoDB table(String table) {
        return (DynamoDB)this.setParam("table", table);
    }

    public DynamoDB accessKey(String key) {
        return (DynamoDB)this.setParam("auth.access_key", key);
    }

    public DynamoDB secretKey(String secret) {
        return (DynamoDB)this.setParam("auth.secret_key", secret);
    }

    public DynamoDB region(Region region) {
        return (DynamoDB)this.setParam("region", region.getRegion());
    }

    public static class Region {
        public static final Region AP_NORTH_EAST_1 = new Region("dynamodb.ap-northeast-1.amazonaws.com");
        public static final Region AP_SOUTH_EAST_1 = new Region("dynamodb.ap-southeast-1.amazonaws.com");
        public static final Region EU_WEST_1 = new Region("dynamodb.eu-west-1.amazonaws.com");
        public static final Region US_EAST_1 = new Region("dynamodb.us-east-1.amazonaws.com");
        public static final Region US_WEST_1 = new Region("dynamodb.us-west-1.amazonaws.com");
        public static final Region US_WEST_2 = new Region("dynamodb.us-west-2.amazonaws.com");
        protected final String region;

        public Region(String region) {
            if (region == null || region.isEmpty()) {
                throw new IllegalArgumentException("Region can't be empty or null");
            }
            this.region = region;
        }

        public String getRegion() {
            return this.region;
        }
    }
}

