/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push.connectors;

import com.datasift.client.push.OutputType;
import com.datasift.client.push.connectors.BaseConnector;

public class ElasticSearch
extends BaseConnector<ElasticSearch> {
    public ElasticSearch() {
        super(OutputType.ELASTIC_SEARCH);
        this.setup(this, "host");
    }

    public ElasticSearch url(String host, int port) {
        return this.host(host).port(port);
    }

    public ElasticSearch host(String host) {
        return (ElasticSearch)this.setParam("host", host);
    }

    public ElasticSearch port(int host) {
        return (ElasticSearch)this.setParam("port", String.valueOf(host));
    }

    public ElasticSearch index(String indexName) {
        return (ElasticSearch)this.setParam("index", indexName);
    }

    public ElasticSearch type(String type) {
        return (ElasticSearch)this.setParam("type", type);
    }

    public ElasticSearch format(ElasticSearchFormat format) {
        String strFormat;
        switch (format) {
            case FULL_INTERACTION_META: {
                strFormat = "full_interaction_meta";
                break;
            }
            default: {
                strFormat = "basic_interaction_meta";
            }
        }
        return (ElasticSearch)this.setParam("format", strFormat);
    }

    public static enum ElasticSearchFormat {
        BASIC_INTERACTION_META,
        FULL_INTERACTION_META;


        public static ElasticSearchFormat fromStr(String str) {
            try {
                return ElasticSearchFormat.valueOf(str.toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                return ElasticSearchFormat.valueOf(str);
            }
        }
    }
}

