/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client;

import com.datasift.client.DataSiftResult;
import com.datasift.client.Response;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public class BaseDataSiftResult
implements DataSiftResult {
    @JsonProperty
    protected String error;
    protected Response response;
    private Throwable cause;
    private boolean failed;

    @Override
    public boolean isSuccessful() {
        return !this.failed && this.response != null && this.error == null && this.response.status() > 199 && this.response.status() < 400;
    }

    @Override
    public Response getResponse() {
        return this.response;
    }

    @Override
    public void setResponse(Response response) {
        this.response = response;
        this.failed = this.failed ? this.failed : response.hasFailed();
        this.cause = this.cause != null ? this.cause : response.failureCause();
    }

    @Override
    public Throwable failureCause() {
        return this.cause;
    }

    @Override
    public boolean isAuthorizationSuccesful() {
        return this.isSuccessful() && this.response.status() != 401;
    }

    @Override
    public int rateLimit() {
        List<String> limit = this.response.headers().get("X-RateLimit-Limit");
        return limit == null || limit.size() == 0 ? Integer.MIN_VALUE : Integer.parseInt(limit.get(0));
    }

    @Override
    public int rateLimitRemaining() {
        List<String> limit = this.response.headers().get("X-RateLimit-Remaining");
        return limit == null || limit.size() == 0 ? Integer.MIN_VALUE : Integer.parseInt(limit.get(0));
    }

    @Override
    public int rateLimitCost() {
        List<String> limit = this.response.headers().get("X-RateLimit-Cost");
        return limit == null || limit.size() == 0 ? Integer.MIN_VALUE : Integer.parseInt(limit.get(0));
    }

    @Override
    public String getError() {
        return this.error;
    }

    public String toString() {
        return this.response.toString();
    }

    @Override
    public void failed(Throwable e) {
        this.failed = e != null;
        this.cause = e;
    }

    @Override
    public void successful() {
        this.failed = false;
    }
}

