/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.managedsource.sources;

import com.datasift.client.DataSiftConfig;
import com.datasift.client.managedsource.ManagedDataSourceType;
import com.datasift.client.managedsource.sources.BaseSource;

public class Instagram
extends BaseSource<Instagram> {
    public Instagram(DataSiftConfig config) {
        super(config, ManagedDataSourceType.INSTAGRAM);
    }

    public Instagram enableLikes(boolean enabled) {
        return (Instagram)this.setParametersField("likes", enabled);
    }

    public Instagram enableComments(boolean enabled) {
        return (Instagram)this.setParametersField("comments", enabled);
    }

    public Instagram byUser(String userId) {
        this.addResource(Type.USER, userId, -1.0f, -1.0f, -1, false, null);
        return this;
    }

    public Instagram byTag(String tag, boolean exactMatch) {
        this.addResource(Type.TAG, tag, -1.0f, -1.0f, -1, exactMatch, null);
        return this;
    }

    public Instagram byArea(float longitude, float lattitude) {
        return this.byArea(longitude, lattitude);
    }

    public Instagram byArea(float longitude, float latitude, int distance) {
        this.addResource(Type.AREA, null, longitude, latitude, distance, false, null);
        return this;
    }

    public Instagram byLocation(float longitude, float latitude) {
        return this.byLocation(longitude, latitude, 0);
    }

    public Instagram byLocation(float longitude, float latitude, int distance) {
        this.addResource(Type.LOCATION, null, longitude, latitude, distance, false, null);
        return this;
    }

    public Instagram byFoursquareLocation(String fourSquareLocation) {
        this.addResource(Type.LOCATION, null, -1.0f, -1.0f, -1, false, fourSquareLocation);
        return this;
    }

    public Instagram byPopularity() {
        this.addResource(Type.POPULAR, null, -1.0f, -1.0f, -1, false, null);
        return this;
    }

    protected Instagram addResource(Type type, String value, float longitude, float lattitude, int distance, boolean exactMatch, String fourSquareLocation) {
        BaseSource.ResourceParams parameterSet = this.newResourceParams();
        switch (type) {
            case USER: {
                if (value == null) {
                    throw new IllegalArgumentException("If type is user then value is required");
                }
                parameterSet.set("type", "user");
                parameterSet.set("value", value);
                break;
            }
            case TAG: {
                if (value == null) {
                    throw new IllegalArgumentException("If type is user then value is required");
                }
                parameterSet.set("type", "tag");
                parameterSet.set("value", value);
                parameterSet.set("extact_match", exactMatch);
                break;
            }
            case AREA: 
            case LOCATION: {
                if (value == null || distance > 5000) {
                    throw new IllegalArgumentException("If provided distance must be between 1 and 5000 metres or < 0 to be ignored");
                }
                if (type == Type.LOCATION) {
                    parameterSet.set("type", "location");
                    if (fourSquareLocation != null) {
                        parameterSet.set("foursq", fourSquareLocation);
                    }
                } else {
                    parameterSet.set("type", "area");
                }
                if (fourSquareLocation != null) break;
                parameterSet.set("lat", Float.valueOf(lattitude));
                parameterSet.set("lng", Float.valueOf(longitude));
                if (distance <= 0) break;
                parameterSet.set("distance", Float.valueOf(lattitude));
                break;
            }
            case POPULAR: {
                parameterSet.set("type", "popular");
            }
        }
        return this;
    }

    public Instagram addOAutToken(String oAuthAccessToken, long expires, String name) {
        if (oAuthAccessToken == null || oAuthAccessToken.isEmpty()) {
            throw new IllegalArgumentException("A valid OAuth and refresh token is required");
        }
        BaseSource.AuthParams parameterSet = this.newAuthParams(name, expires);
        parameterSet.set("value", oAuthAccessToken);
        return this;
    }

    public static enum Type {
        USER,
        TAG,
        AREA,
        LOCATION,
        POPULAR;

    }
}

