/*
 * Decompiled with CFR 0.152.
 */
package com.datasift.client.push;

import com.datasift.client.DataSiftClient;
import com.datasift.client.exceptions.IllegalDataSiftPullFormat;
import com.datasift.client.exceptions.PushSubscriptionNotFound;
import com.datasift.client.push.PulledInteractions;
import com.datasift.client.stream.Interaction;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.higgs.http.client.readers.Reader;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;

public class PullReader
extends Reader<String> {
    public static final String HEADER_NEXT_CURSOR = "X-DataSift-Cursor-Next";
    public static final String HEADER_CURRENT_CURSOR = "X-DataSift-Cursor-Current";
    public static final String HEADER_FORMAT = "X-DataSift-Format";
    public static final String FORMAT_ARRAY = "json_array";
    public static final String FORMAT_META = "json_meta";
    public static final String FORMAT_NEW_LINE = "json_new_line";
    protected String currentCursor;
    protected String nextCursor;
    protected String format;
    protected final PulledInteractions queue;
    private boolean done;
    private boolean headersSet;
    protected int status = -1;
    protected int backOff = 1;
    protected int successiveNoContent;

    public PullReader(PulledInteractions queue) {
        this.queue = queue;
    }

    public void onStatus(HttpResponseStatus status) {
        super.onStatus(status);
        this.status = status.code();
        this.checkResponseStatus();
        if (this.status == 204) {
            ++this.successiveNoContent;
        }
    }

    protected boolean checkResponseStatus() {
        switch (this.status) {
            case 404: {
                throw new PushSubscriptionNotFound(this.response);
            }
            case 403: 
            case 429: {
                this.backOff = 30;
                break;
            }
            case 204: 
            case 500: 
            case 503: {
                this.backOff *= 2;
                if (this.backOff <= 60) break;
                this.backOff = 60;
                break;
            }
            case 200: {
                this.backOff = 0;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public void onHeaders(HttpHeaders headers) {
        super.onHeaders(headers);
        this.checkHeaders();
        this.headersSet = true;
    }

    protected void checkHeaders() {
        HttpHeaders headers = this.response.getHeaders();
        if (headers != null && headers.names() != null) {
            for (String k : headers.names()) {
                if (HEADER_CURRENT_CURSOR.equalsIgnoreCase(k)) {
                    this.currentCursor = headers.get(k);
                    continue;
                }
                if (HEADER_NEXT_CURSOR.equalsIgnoreCase(k)) {
                    this.nextCursor = headers.get(k);
                    continue;
                }
                if (!HEADER_FORMAT.equalsIgnoreCase(k)) continue;
                this.format = headers.get(k);
            }
        }
    }

    public void data(ByteBuf data) {
        this.buffer.writeBytes(data);
        this.processData();
    }

    public void done() {
        this.done = true;
        this.processData();
    }

    protected void processData() {
        this.checkHeaders();
        if (this.backOff == 0 && this.status != 204 && this.headersSet && (this.format == null || this.format.isEmpty())) {
            throw new IllegalDataSiftPullFormat("The DataSift API failed to provide the format of the data. Please raise the issue with support", this.response);
        }
        if (this.format != null) {
            switch (this.format) {
                case "json_new_line": {
                    if (!this.done) break;
                    this.readLineByLine();
                    break;
                }
                case "json_array": {
                    this.readArray();
                    break;
                }
                case "json_meta": {
                    this.readObject();
                    break;
                }
                default: {
                    throw new IllegalDataSiftPullFormat("DataSift format '" + this.format + "' is not supported", this.response);
                }
            }
        }
    }

    protected void send(Interaction interaction) {
        this.queue.add(interaction);
    }

    protected void readObject() {
        if (this.done) {
            String data = this.getDataAsString();
            if (data == null || data.isEmpty()) {
                return;
            }
            try {
                ObjectNode meta = (ObjectNode)DataSiftClient.MAPPER.readTree(data);
                ArrayNode interactions = (ArrayNode)meta.get("interactions");
                for (JsonNode interaction : interactions) {
                    this.send(new Interaction(interaction));
                }
                this.buffer.discardReadBytes();
            }
            catch (IOException e) {
                this.log.warn("Failed to decode interactions", (Throwable)e);
            }
        }
    }

    protected void readArray() {
        if (this.done) {
            String data = this.getDataAsString();
            if (data == null || data.isEmpty()) {
                return;
            }
            try {
                ArrayNode interactions = (ArrayNode)DataSiftClient.MAPPER.readTree(data);
                for (JsonNode interaction : interactions) {
                    this.send(new Interaction(interaction));
                }
                this.buffer.discardReadBytes();
            }
            catch (IOException e) {
                this.log.warn("Failed to decode interactions", (Throwable)e);
            }
        }
    }

    protected void readLineByLine() {
        try {
            String line;
            while ((line = this.data.readLine()) != null) {
                ObjectNode interaction = (ObjectNode)DataSiftClient.MAPPER.readTree(line);
                this.send(new Interaction((JsonNode)interaction));
            }
            this.buffer.discardReadBytes();
        }
        catch (IOException e) {
            this.log.info("Failed to decode interaction ", (Throwable)e);
        }
    }

    protected String getDataAsString() {
        String str = this.buffer.toString(0, this.buffer.writerIndex(), utf8);
        this.buffer.readerIndex(this.buffer.writerIndex());
        return str;
    }

    public void reset() {
        if (this.status == 200 || this.backOff >= 60) {
            this.successiveNoContent = 0;
            this.backOff = 1;
        }
        this.format = null;
        this.nextCursor = null;
        this.currentCursor = null;
        this.done = false;
        this.status = -1;
        this.headersSet = false;
    }
}

