/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.mapper.processor;

import com.datastax.dse.driver.internal.mapper.processor.DseProcessorContext;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoDeleteMethodGenerator;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoImplementationGenerator;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoInsertMethodGenerator;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoQueryMethodGenerator;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoReturnTypeParser;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoSelectMethodGenerator;
import com.datastax.dse.driver.internal.mapper.processor.dao.DseDaoUpdateMethodGenerator;
import com.datastax.dse.driver.internal.mapper.processor.mapper.DseMapperBuilderGenerator;
import com.datastax.oss.driver.api.mapper.annotations.Delete;
import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.api.mapper.annotations.Query;
import com.datastax.oss.driver.api.mapper.annotations.Select;
import com.datastax.oss.driver.api.mapper.annotations.Update;
import com.datastax.oss.driver.internal.mapper.processor.CodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.DefaultCodeGeneratorFactory;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeParser;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;

public class DseCodeGeneratorFactory
extends DefaultCodeGeneratorFactory {
    private final DseDaoReturnTypeParser daoReturnTypeParser;

    public DseCodeGeneratorFactory(DseProcessorContext context) {
        super(context);
        this.daoReturnTypeParser = new DseDaoReturnTypeParser(context);
    }

    @Override
    public CodeGenerator newMapperBuilder(TypeElement interfaceElement) {
        return new DseMapperBuilderGenerator(interfaceElement, this.context);
    }

    @Override
    public DaoReturnTypeParser getDaoReturnTypeParser() {
        return this.daoReturnTypeParser;
    }

    @Override
    public CodeGenerator newDaoImplementation(TypeElement interfaceElement) {
        return new DseDaoImplementationGenerator(interfaceElement, this.context);
    }

    @Override
    public Optional<MethodGenerator> newDaoImplementationMethod(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, TypeElement processedType, DaoImplementationSharedCode enclosingClass) {
        if (methodElement.getAnnotation(Select.class) != null) {
            return Optional.of(new DseDaoSelectMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Insert.class) != null) {
            return Optional.of(new DseDaoInsertMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Update.class) != null) {
            return Optional.of(new DseDaoUpdateMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Delete.class) != null) {
            return Optional.of(new DseDaoDeleteMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        if (methodElement.getAnnotation(Query.class) != null) {
            return Optional.of(new DseDaoQueryMethodGenerator(methodElement, typeParameters, processedType, enclosingClass, this.context));
        }
        return super.newDaoImplementationMethod(methodElement, typeParameters, processedType, enclosingClass);
    }
}

