/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.mapper.processor.dao;

import com.datastax.dse.driver.internal.core.cql.reactive.FailedReactiveResultSet;
import com.datastax.dse.driver.internal.mapper.reactive.FailedMappedReactiveResultSet;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoReturnTypeKind;
import com.squareup.javapoet.CodeBlock;

public enum DseDaoReturnTypeKind implements DaoReturnTypeKind
{
    REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeReactive(boundStatement)", new Object[0]);
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T t)", new Object[]{Throwable.class}).addStatement("return new $T(t)", new Object[]{FailedReactiveResultSet.class}).endControlFlow().build();
        }
    }
    ,
    MAPPED_REACTIVE_RESULT_SET{

        @Override
        public void addExecuteStatement(CodeBlock.Builder methodBuilder, String helperFieldName) {
            methodBuilder.addStatement("return executeReactiveAndMap(boundStatement, $L)", new Object[]{helperFieldName});
        }

        @Override
        public CodeBlock wrapWithErrorHandling(CodeBlock innerBlock) {
            return CodeBlock.builder().beginControlFlow("try", new Object[0]).add(innerBlock).nextControlFlow("catch ($T t)", new Object[]{Throwable.class}).addStatement("return new $T(t)", new Object[]{FailedMappedReactiveResultSet.class}).endControlFlow().build();
        }
    };


    @Override
    public String getDescription() {
        return this.name();
    }
}

