/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor;

import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.Mapper;
import com.datastax.oss.driver.internal.mapper.processor.CodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.CodeGeneratorFactory;
import com.datastax.oss.driver.internal.mapper.processor.DecoratedMessager;
import com.datastax.oss.driver.internal.mapper.processor.DefaultProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.shaded.guava.common.base.Strings;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.google.common.base.Throwables;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public class MapperProcessor
extends AbstractProcessor {
    private static final boolean DEFAULT_MAPPER_LOGS_ENABLED = true;
    private static final String INDENT_AMOUNT_OPTION = "com.datastax.oss.driver.mapper.indent";
    private static final String INDENT_WITH_TABS_OPTION = "com.datastax.oss.driver.mapper.indentWithTabs";
    private static final String MAPPER_LOGS_ENABLED_OPTION = "com.datastax.oss.driver.mapper.logs.enabled";
    private DecoratedMessager messager;
    private Types typeUtils;
    private Elements elementUtils;
    private Filer filer;
    private String indent;
    private boolean logsEnabled;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.messager = new DecoratedMessager(processingEnvironment.getMessager());
        this.typeUtils = processingEnvironment.getTypeUtils();
        this.elementUtils = processingEnvironment.getElementUtils();
        this.filer = processingEnvironment.getFiler();
        this.indent = this.computeIndent(processingEnvironment.getOptions());
        this.logsEnabled = this.isLogsEnabled(processingEnvironment.getOptions());
    }

    private boolean isLogsEnabled(Map<String, String> options) {
        String mapperLogsEnabled = options.get(MAPPER_LOGS_ENABLED_OPTION);
        if (mapperLogsEnabled != null) {
            return Boolean.parseBoolean(mapperLogsEnabled);
        }
        return true;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnvironment) {
        ProcessorContext context = this.buildContext(this.messager, this.typeUtils, this.elementUtils, this.filer, this.indent, this.logsEnabled);
        CodeGeneratorFactory generatorFactory = context.getCodeGeneratorFactory();
        this.processAnnotatedTypes(roundEnvironment, Entity.class, ElementKind.CLASS, generatorFactory::newEntity);
        this.processAnnotatedTypes(roundEnvironment, Dao.class, ElementKind.INTERFACE, generatorFactory::newDaoImplementation);
        this.processAnnotatedTypes(roundEnvironment, Mapper.class, ElementKind.INTERFACE, generatorFactory::newMapper);
        return true;
    }

    protected ProcessorContext buildContext(DecoratedMessager messager, Types typeUtils, Elements elementUtils, Filer filer, String indent, boolean logsEnabled) {
        return new DefaultProcessorContext(messager, typeUtils, elementUtils, filer, indent, logsEnabled);
    }

    protected void processAnnotatedTypes(RoundEnvironment roundEnvironment, Class<? extends Annotation> annotationClass, ElementKind expectedKind, Function<TypeElement, CodeGenerator> generatorFactory) {
        for (Element element : roundEnvironment.getElementsAnnotatedWith(annotationClass)) {
            if (element.getKind() != expectedKind) {
                this.messager.error(element, "Only %s elements can be annotated with %s", new Object[]{expectedKind, annotationClass.getSimpleName()});
                continue;
            }
            TypeElement typeElement = (TypeElement)element;
            try {
                generatorFactory.apply(typeElement).generate();
            }
            catch (Exception e) {
                this.messager.error(element, "Unexpected error while writing generated code: %s", Throwables.getStackTraceAsString((Throwable)e));
            }
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)Entity.class.getName(), (Object)Mapper.class.getName(), (Object)Dao.class.getName());
    }

    @Override
    public Set<String> getSupportedOptions() {
        return ImmutableSet.of((Object)INDENT_AMOUNT_OPTION, (Object)INDENT_WITH_TABS_OPTION, (Object)MAPPER_LOGS_ENABLED_OPTION);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private String computeIndent(Map<String, String> options) {
        boolean tabs = options.containsKey(INDENT_WITH_TABS_OPTION);
        String amountSpec = options.get(INDENT_AMOUNT_OPTION);
        if (amountSpec != null) {
            try {
                int amount = Integer.parseInt(amountSpec);
                return Strings.repeat((String)(tabs ? "\t" : " "), (int)amount);
            }
            catch (NumberFormatException e) {
                this.messager.warn("Could not parse %s: expected a number, got '%s'. Defaulting to %s.", INDENT_AMOUNT_OPTION, amountSpec, tabs ? "1 tab" : "2 spaces");
            }
        }
        return tabs ? "\t" : "  ";
    }
}

