/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.Entity;
import com.datastax.oss.driver.api.mapper.annotations.QueryProvider;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoImplementationSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.dao.EntityUtils;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GeneratedCodePatterns;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class DaoQueryProviderMethodGenerator
extends DaoMethodGenerator {
    public DaoQueryProviderMethodGenerator(ExecutableElement methodElement, Map<Name, TypeElement> typeParameters, DaoImplementationSharedCode enclosingClass, ProcessorContext context) {
        super(methodElement, typeParameters, enclosingClass, context);
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder methodBuilder = GeneratedCodePatterns.override(this.methodElement, this.typeParameters);
        List<ClassName> entityHelperTypes = this.getEntityHelperTypes();
        String providerName = this.enclosingClass.addQueryProvider(this.methodElement, this.getProviderClass(), entityHelperTypes);
        String providerMethod = this.methodElement.getAnnotation(QueryProvider.class).providerMethod();
        if (providerMethod.isEmpty()) {
            providerMethod = this.methodElement.getSimpleName().toString();
        }
        methodBuilder.addCode("$[", new Object[0]);
        if (this.methodElement.getReturnType().getKind() != TypeKind.VOID) {
            methodBuilder.addCode("return ", new Object[0]);
        }
        methodBuilder.addCode("$L.$L(", new Object[]{providerName, providerMethod});
        boolean first = true;
        for (VariableElement variableElement : this.methodElement.getParameters()) {
            if (first) {
                first = false;
            } else {
                methodBuilder.addCode(", ", new Object[0]);
            }
            methodBuilder.addCode("$L", new Object[]{variableElement.getSimpleName().toString()});
        }
        methodBuilder.addCode(");$]\n", new Object[0]);
        return Optional.of(methodBuilder.build());
    }

    private TypeMirror getProviderClass() {
        AnnotationMirror annotationMirror = this.getQueryProviderAnnotationMirror();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("providerClass")) continue;
            return (TypeMirror)entry.getValue().getValue();
        }
        return this.context.getTypeUtils().getPrimitiveType(TypeKind.INT);
    }

    private List<ClassName> getEntityHelperTypes() {
        AnnotationMirror annotationMirror = this.getQueryProviderAnnotationMirror();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals("entityHelpers")) continue;
            List values = (List)entry.getValue().getValue();
            ArrayList<ClassName> result = new ArrayList<ClassName>(values.size());
            for (AnnotationValue value : values) {
                TypeMirror entityMirror = (TypeMirror)value.getValue();
                TypeElement entityElement = EntityUtils.asEntityElement(entityMirror, (Map<Name, TypeElement>)this.typeParameters);
                if (entityElement == null) {
                    this.context.getMessager().error(this.methodElement, "Invalid annotation configuration: the elements in %s.entityHelpers must be %s-annotated classes (offending element: %s)", QueryProvider.class.getSimpleName(), Entity.class.getSimpleName(), entityMirror);
                    return Collections.emptyList();
                }
                result.add(ClassName.get((TypeElement)entityElement));
            }
            return result;
        }
        return Collections.emptyList();
    }

    private AnnotationMirror getQueryProviderAnnotationMirror() {
        for (AnnotationMirror annotationMirror : this.methodElement.getAnnotationMirrors()) {
            if (!this.context.getClassUtils().isSame(annotationMirror.getAnnotationType(), QueryProvider.class)) continue;
            return annotationMirror;
        }
        throw new AssertionError((Object)"Expected to find QueryProvider annotation");
    }
}

