/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperDeleteByPrimaryKeyMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    public EntityHelperDeleteByPrimaryKeyMethodGenerator(EntityDefinition entityDefinition, EntityHelperGenerator enclosingClass, ProcessorContext context) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder deleteByPrimaryKeyBuilder = MethodSpec.methodBuilder((String)"deleteByPrimaryKey").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Delete.class);
        if (this.entityDefinition.getPrimaryKey().isEmpty()) {
            deleteByPrimaryKeyBuilder.addStatement("throw new $T($S)", new Object[]{MapperException.class, String.format("Entity %s does not declare a primary key", this.entityDefinition.getClassName().simpleName())});
        } else {
            deleteByPrimaryKeyBuilder.addStatement("throwIfKeyspaceMissing()", new Object[0]).addStatement("$1T delete = (keyspaceId == null)\n? $2T.deleteFrom(tableId)\n: $2T.deleteFrom(keyspaceId, tableId)", new Object[]{DeleteSelection.class, QueryBuilder.class}).addCode("$[return delete", new Object[0]);
            for (PropertyDefinition property : this.entityDefinition.getPrimaryKey()) {
                deleteByPrimaryKeyBuilder.addCode("\n.whereColumn($1L).isEqualTo($2T.bindMarker($1L))", new Object[]{property.getCqlName(), QueryBuilder.class});
            }
            deleteByPrimaryKeyBuilder.addCode("$];\n", new Object[0]);
        }
        return Optional.of(deleteByPrimaryKeyBuilder.build());
    }
}

