/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.MapperContext;
import com.datastax.oss.driver.internal.mapper.entity.EntityHelperBase;
import com.datastax.oss.driver.internal.mapper.processor.GeneratedNames;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.SingleFileCodeGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperDeleteByPrimaryKeyMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGetMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperInsertMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperSelectByPrimaryKeyMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperSelectStartMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperSetMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperUpdateByPrimaryKeyMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperUpdateStartMethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.util.NameIndex;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.BindableHandlingSharedCode;
import com.datastax.oss.driver.internal.mapper.processor.util.generation.GenericTypeConstantGenerator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.beans.Introspector;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public class EntityHelperGenerator
extends SingleFileCodeGenerator
implements BindableHandlingSharedCode {
    private final TypeElement classElement;
    private final ClassName helperName;
    private final NameIndex nameIndex = new NameIndex();
    private final GenericTypeConstantGenerator genericTypeConstantGenerator = new GenericTypeConstantGenerator(this.nameIndex);
    private final Map<ClassName, String> childHelpers = new HashMap<ClassName, String>();

    public EntityHelperGenerator(TypeElement classElement, ProcessorContext context) {
        super(context);
        this.classElement = classElement;
        this.helperName = GeneratedNames.entityHelper(classElement);
    }

    @Override
    public NameIndex getNameIndex() {
        return this.nameIndex;
    }

    @Override
    protected ClassName getPrincipalTypeName() {
        return this.helperName;
    }

    @Override
    public String addGenericTypeConstant(TypeName type) {
        return this.genericTypeConstantGenerator.add(type);
    }

    @Override
    public String addEntityHelperField(ClassName childEntityName) {
        return this.childHelpers.computeIfAbsent(childEntityName, k -> {
            String baseName = Introspector.decapitalize(childEntityName.simpleName()) + "Helper";
            return this.nameIndex.uniqueField(baseName);
        });
    }

    @Override
    protected JavaFile.Builder getContents() {
        EntityDefinition entityDefinition = this.context.getEntityFactory().getDefinition(this.classElement);
        TypeSpec.Builder classContents = TypeSpec.classBuilder((ClassName)this.helperName).addJavadoc("Generated by the DataStax driver mapper, do not edit directly.\n", new Object[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).superclass((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(EntityHelperBase.class), (TypeName[])new TypeName[]{ClassName.get((TypeElement)this.classElement)}));
        this.context.getLoggingGenerator().addLoggerField(classContents, this.helperName);
        classContents.addMethod(MethodSpec.methodBuilder((String)"getEntityClass").addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{entityDefinition.getClassName()})).addStatement("return $T.class", new Object[]{entityDefinition.getClassName()}).build());
        for (MethodGenerator methodGenerator : ImmutableList.of((Object)new EntityHelperSetMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperGetMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperInsertMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperSelectByPrimaryKeyMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperSelectStartMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperDeleteByPrimaryKeyMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperUpdateStartMethodGenerator(entityDefinition, this, this.context), (Object)new EntityHelperUpdateByPrimaryKeyMethodGenerator(entityDefinition, this, this.context))) {
            methodGenerator.generate().ifPresent(arg_0 -> ((TypeSpec.Builder)classContents).addMethod(arg_0));
        }
        MethodSpec.Builder constructorContents = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        constructorContents.addParameter((TypeName)ClassName.get(MapperContext.class), "context", new Modifier[0]);
        if (entityDefinition.getDefaultKeyspace() == null) {
            constructorContents.addStatement("super(context, $L)", new Object[]{entityDefinition.getCqlName()});
        } else {
            constructorContents.addStatement("super(context, $S, $L)", new Object[]{entityDefinition.getDefaultKeyspace(), entityDefinition.getCqlName()});
        }
        this.context.getLoggingGenerator().debug(constructorContents, String.format("[{}] Entity %s will be mapped to {}{}", entityDefinition.getClassName().simpleName()), CodeBlock.of((String)"context.getSession().getName()", (Object[])new Object[0]), CodeBlock.of((String)"getKeyspaceId() == null ? \"\" : getKeyspaceId() + \".\"", (Object[])new Object[0]), CodeBlock.of((String)"getTableId()", (Object[])new Object[0]));
        this.genericTypeConstantGenerator.generate(classContents);
        for (Map.Entry<ClassName, String> entry : this.childHelpers.entrySet()) {
            ClassName childEntityName = entry.getKey();
            String fieldName = entry.getValue();
            ClassName helperClassName = GeneratedNames.entityHelper(childEntityName);
            classContents.addField(FieldSpec.builder((TypeName)helperClassName, (String)fieldName, (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build());
            constructorContents.addStatement("this.$L = new $T(context)", new Object[]{fieldName, helperClassName});
        }
        classContents.addMethod(constructorContents.build());
        return JavaFile.builder((String)this.helperName.packageName(), (TypeSpec)classContents.build());
    }
}

