/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.insert.InsertInto;
import com.datastax.oss.driver.api.querybuilder.insert.RegularInsert;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperInsertMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    public EntityHelperInsertMethodGenerator(EntityDefinition entityDefinition, EntityHelperGenerator enclosingClass, ProcessorContext context) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder insertBuilder = MethodSpec.methodBuilder((String)"insert").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(RegularInsert.class).addStatement("throwIfKeyspaceMissing()", new Object[0]).addStatement("$1T insertInto = (keyspaceId == null)\n? $2T.insertInto(tableId)\n: $2T.insertInto(keyspaceId, tableId)", new Object[]{InsertInto.class, QueryBuilder.class}).addCode("$[return insertInto", new Object[0]);
        for (PropertyDefinition property : this.entityDefinition.getAllColumns()) {
            insertBuilder.addCode("\n.value($1L, $2T.bindMarker($1L))", new Object[]{property.getCqlName(), QueryBuilder.class});
        }
        insertBuilder.addCode("$];\n", new Object[0]);
        return Optional.of(insertBuilder.build());
    }
}

