/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperSelectByPrimaryKeyMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    public EntityHelperSelectByPrimaryKeyMethodGenerator(EntityDefinition entityDefinition, EntityHelperGenerator enclosingClass, ProcessorContext context) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder selectByPrimaryKeyBuilder = MethodSpec.methodBuilder((String)"selectByPrimaryKey").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Select.class).addCode("$[return selectStart()", new Object[0]);
        for (PropertyDefinition property : this.entityDefinition.getPrimaryKey()) {
            selectByPrimaryKeyBuilder.addCode("\n.whereColumn($1L).isEqualTo($2T.bindMarker($1L))", new Object[]{property.getCqlName(), QueryBuilder.class});
        }
        selectByPrimaryKeyBuilder.addCode("$];\n", new Object[0]);
        return Optional.of(selectByPrimaryKeyBuilder.build());
    }
}

