/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.select.Select;
import com.datastax.oss.driver.api.querybuilder.select.SelectFrom;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.ProcessorContext;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityHelperGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.PropertyDefinition;
import com.squareup.javapoet.MethodSpec;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperSelectStartMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    public EntityHelperSelectStartMethodGenerator(EntityDefinition entityDefinition, EntityHelperGenerator enclosingClass, ProcessorContext context) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder selectStartBuilder = MethodSpec.methodBuilder((String)"selectStart").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Select.class).addStatement("throwIfKeyspaceMissing()", new Object[0]).addStatement("$1T selectFrom = (keyspaceId == null)\n? $2T.selectFrom(tableId)\n: $2T.selectFrom(keyspaceId, tableId)", new Object[]{SelectFrom.class, QueryBuilder.class}).addCode("$[return selectFrom", new Object[0]);
        for (PropertyDefinition property : this.entityDefinition.getAllColumns()) {
            selectStartBuilder.addCode("\n.column($L)", new Object[]{property.getSelector()});
        }
        for (PropertyDefinition property : this.entityDefinition.getComputedValues()) {
            selectStartBuilder.addCode("\n.raw($L).as($L)", new Object[]{property.getSelector(), property.getCqlName()});
        }
        selectStartBuilder.addCode("$];\n", new Object[0]);
        return Optional.of(selectStartBuilder.build());
    }
}

