/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.entity;

import com.datastax.oss.driver.api.mapper.MapperException;
import com.datastax.oss.driver.api.querybuilder.QueryBuilder;
import com.datastax.oss.driver.api.querybuilder.delete.Delete;
import com.datastax.oss.driver.api.querybuilder.delete.DeleteSelection;
import com.datastax.oss.driver.internal.mapper.processor.MethodGenerator;
import com.datastax.oss.driver.internal.mapper.processor.entity.EntityDefinition;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import java.util.Optional;
import javax.lang.model.element.Modifier;

public class EntityHelperDeleteByPrimaryKeyPartsMethodGenerator
implements MethodGenerator {
    private final EntityDefinition entityDefinition;

    public EntityHelperDeleteByPrimaryKeyPartsMethodGenerator(EntityDefinition entityDefinition) {
        this.entityDefinition = entityDefinition;
    }

    @Override
    public Optional<MethodSpec> generate() {
        MethodSpec.Builder deleteByPrimaryKeyPartsBuilder = MethodSpec.methodBuilder((String)"deleteByPrimaryKeyParts").addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.INT, "parameterCount", new Modifier[0]).returns(Delete.class);
        if (this.entityDefinition.getPrimaryKey().isEmpty()) {
            deleteByPrimaryKeyPartsBuilder.addStatement("throw new $T($S)", new Object[]{MapperException.class, String.format("Entity %s does not declare a primary key", this.entityDefinition.getClassName().simpleName())});
        } else {
            deleteByPrimaryKeyPartsBuilder.beginControlFlow("if (parameterCount <= 0)", new Object[0]);
            deleteByPrimaryKeyPartsBuilder.addStatement("throw new $T($S)", new Object[]{MapperException.class, "parameterCount must be greater than 0"});
            deleteByPrimaryKeyPartsBuilder.endControlFlow();
            deleteByPrimaryKeyPartsBuilder.addStatement("$1T deleteSelection = deleteStart()", new Object[]{DeleteSelection.class});
            deleteByPrimaryKeyPartsBuilder.addStatement("$1T columnName = primaryKeys.get(0)", new Object[]{String.class});
            deleteByPrimaryKeyPartsBuilder.addStatement("$1T delete = deleteSelection.whereColumn(columnName).isEqualTo($2T.bindMarker(columnName))", new Object[]{Delete.class, QueryBuilder.class});
            deleteByPrimaryKeyPartsBuilder.beginControlFlow("for (int i = 1; i < parameterCount && i < primaryKeys.size(); i++)", new Object[0]);
            deleteByPrimaryKeyPartsBuilder.addStatement("columnName = primaryKeys.get(i)", new Object[0]);
            deleteByPrimaryKeyPartsBuilder.addStatement("delete = delete.whereColumn(columnName).isEqualTo($1T.bindMarker(columnName))", new Object[]{QueryBuilder.class});
            deleteByPrimaryKeyPartsBuilder.endControlFlow();
            deleteByPrimaryKeyPartsBuilder.addStatement("return delete", new Object[0]);
        }
        return Optional.of(deleteByPrimaryKeyPartsBuilder.build());
    }
}

