/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.internal.mapper.processor.MapperProcessorTest;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeSpec;
import javax.lang.model.element.Modifier;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;
import org.junit.Test;

public class DaoAnnotationTest
extends MapperProcessorTest {
    @Test
    public void should_work_on_nested_interface() {
        Compilation compilation = this.compileWithMapperProcessor("test", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Foo", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addType(TypeSpec.interfaceBuilder((String)"Bar").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addAnnotation(Dao.class).build()).build());
        CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        CompilationSubject.assertThat((Compilation)compilation).generatedFile((JavaFileManager.Location)StandardLocation.SOURCE_OUTPUT, "test", "Foo_BarImpl__MapperGenerated.java").contentsAsUtf8String().contains((CharSequence)"class Foo_BarImpl__MapperGenerated extends DaoBase implements Foo.Bar");
    }

    @Test
    public void should_fail_on_class() {
        this.should_fail_with_expected_error("Only INTERFACE elements can be annotated with Dao", "test", TypeSpec.classBuilder((ClassName)ClassName.get((String)"test", (String)"Foo", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).build());
    }
}

