/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.CqlName;
import com.datastax.oss.driver.api.mapper.annotations.Dao;
import com.datastax.oss.driver.api.mapper.annotations.Delete;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGeneratorTest;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.google.testing.compile.Compilation;
import com.google.testing.compile.CompilationSubject;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import javax.lang.model.element.Modifier;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DaoDeleteMethodGeneratorTest
extends DaoMethodGeneratorTest {
    @Override
    @Test
    @UseDataProvider(value="invalidSignatures")
    public void should_fail_with_expected_error(String expectedError, MethodSpec method, TypeSpec entitySpec) {
        super.should_fail_with_expected_error(expectedError, method, entitySpec);
    }

    @DataProvider
    public static Object[][] invalidSignatures() {
        return new Object[][]{{"Invalid annotation parameters: Delete cannot have both ifExists and customIfClause", MethodSpec.methodBuilder((String)"delete").addAnnotation(AnnotationSpec.builder(Delete.class).addMember("ifExists", "true", new Object[0]).addMember("customIfClause", "$S", new Object[]{"whatever"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build(), ENTITY_SPEC}, {"Wrong number of parameters: Delete methods with no custom clause must take either an entity instance, or the primary key components", MethodSpec.methodBuilder((String)"delete").addAnnotation(Delete.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build(), ENTITY_SPEC}, {"Missing entity class: Delete methods that do not operate on an entity instance must have an 'entityClass' argument", MethodSpec.methodBuilder((String)"delete").addAnnotation(Delete.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(UUID.class, "id", new Modifier[0]).build(), ENTITY_SPEC}, {"Invalid parameter list: Delete methods that do not operate on an entity instance and lack a custom where clause must match the primary key components in the exact order (expected primary key of Product: [java.util.UUID]). Mismatch at index 0: java.lang.Integer should be java.util.UUID", MethodSpec.methodBuilder((String)"delete").addAnnotation(AnnotationSpec.builder(Delete.class).addMember("entityClass", "$T.class", new Object[]{ENTITY_CLASS_NAME}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(Integer.class, "id", new Modifier[0]).build(), ENTITY_SPEC}, {"Invalid parameter list: Delete methods that do not operate on an entity instance and lack a custom where clause must at least specify partition key components (expected partition key of ProductSale: [java.util.UUID, java.lang.String])", MethodSpec.methodBuilder((String)"delete").addAnnotation(AnnotationSpec.builder(Delete.class).addMember("entityClass", "$T.class", new Object[]{SALE_ENTITY_CLASS_NAME}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(Integer.class, "id", new Modifier[0]).build(), SALE_ENTITY_SPEC}, {"Delete methods must return one of [VOID, FUTURE_OF_VOID, BOOLEAN, FUTURE_OF_BOOLEAN, RESULT_SET, BOUND_STATEMENT, FUTURE_OF_ASYNC_RESULT_SET, REACTIVE_RESULT_SET]", MethodSpec.methodBuilder((String)"delete").addAnnotation(Delete.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).returns(Integer.class).build(), ENTITY_SPEC}, {"Wrong number of parameters: Delete methods can only have additional parameters if they specify a custom WHERE or IF clause", MethodSpec.methodBuilder((String)"delete").addAnnotation(Delete.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).addParameter(Integer.class, "extra", new Modifier[0]).build(), ENTITY_SPEC}, {"Delete methods that have a custom where clause must not take an Entity (Product) as a parameter", MethodSpec.methodBuilder((String)"delete").addAnnotation(AnnotationSpec.builder(Delete.class).addMember("customWhereClause", "$S", new Object[]{"hello"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).returns(Integer.class).build(), ENTITY_SPEC}};
    }

    @Test
    public void should_warn_when_non_bind_marker_has_cql_name() {
        this.should_succeed_with_expected_warning("Parameter id does not refer to a bind marker, @CqlName annotation will be ignored", MethodSpec.methodBuilder((String)"delete").addAnnotation(AnnotationSpec.builder(Delete.class).addMember("entityClass", ENTITY_CLASS_NAME + ".class", new Object[0]).addMember("customIfClause", "$S", new Object[]{"description = :description"}).build()).addParameter(ParameterSpec.builder(UUID.class, (String)"id", (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder(CqlName.class).addMember("value", "$S", new Object[]{"irrelevant"}).build()).build()).addParameter(String.class, "description", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build());
    }

    @Test
    public void should_not_fail_on_unsupported_result_when_custom_results_enabled() {
        MethodSpec methodSpec = MethodSpec.methodBuilder((String)"delete").addAnnotation(Delete.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).returns(Integer.class).build();
        TypeSpec daoSpec = TypeSpec.interfaceBuilder((ClassName)ClassName.get((String)"test", (String)"ProductDao", (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Dao.class).addMethod(methodSpec).build();
        for (List compilerOptions : ImmutableList.of((Object)ImmutableList.of((Object)"-Acom.datastax.oss.driver.mapper.customResults.enabled=true"), Collections.emptyList())) {
            Compilation compilation = this.compileWithMapperProcessor("test", compilerOptions, ENTITY_SPEC, daoSpec);
            CompilationSubject.assertThat((Compilation)compilation).succeededWithoutWarnings();
        }
    }
}

