/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.mapper.processor.dao;

import com.datastax.oss.driver.api.mapper.annotations.Insert;
import com.datastax.oss.driver.internal.mapper.processor.dao.DaoMethodGeneratorTest;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import javax.lang.model.element.Modifier;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DaoInsertMethodGeneratorTest
extends DaoMethodGeneratorTest {
    @Override
    @Test
    @UseDataProvider(value="invalidSignatures")
    public void should_fail_with_expected_error(String expectedError, MethodSpec method) {
        super.should_fail_with_expected_error(expectedError, method);
    }

    @DataProvider
    public static Object[][] invalidSignatures() {
        return new Object[][]{{"Insert methods must take the entity to insert as the first parameter", MethodSpec.methodBuilder((String)"insert").addAnnotation(Insert.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).build()}, {"Insert methods must take the entity to insert as the first parameter", MethodSpec.methodBuilder((String)"insert").addAnnotation(Insert.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder(String.class, (String)"a", (Modifier[])new Modifier[0]).build()).build()}, {"Insert methods must return one of [VOID, FUTURE_OF_VOID, ENTITY, FUTURE_OF_ENTITY, OPTIONAL_ENTITY, FUTURE_OF_OPTIONAL_ENTITY, BOOLEAN, FUTURE_OF_BOOLEAN, RESULT_SET, BOUND_STATEMENT, FUTURE_OF_ASYNC_RESULT_SET, REACTIVE_RESULT_SET]", MethodSpec.methodBuilder((String)"insert").addAnnotation(Insert.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter(ParameterSpec.builder((TypeName)ENTITY_CLASS_NAME, (String)"entity", (Modifier[])new Modifier[0]).build()).returns(TypeName.INT).build()}};
    }

    @Override
    @Test
    @UseDataProvider(value="warningSignatures")
    public void should_succeed_with_expected_warning(String expectedWarning, MethodSpec method) {
        super.should_succeed_with_expected_warning(expectedWarning, method);
    }

    @DataProvider
    public static Object[][] warningSignatures() {
        return new Object[][]{{"Invalid ttl value: ':foo bar' is not a valid placeholder, the generated query will probably fail", MethodSpec.methodBuilder((String)"insert").addAnnotation(AnnotationSpec.builder(Insert.class).addMember("ttl", "$S", new Object[]{":foo bar"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).build()}, {"Invalid ttl value: 'foo' is not a bind marker name and can't be parsed as a number literal either, the generated query will probably fail", MethodSpec.methodBuilder((String)"insert").addAnnotation(AnnotationSpec.builder(Insert.class).addMember("ttl", "$S", new Object[]{"foo"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).build()}, {"Invalid timestamp value: ':foo bar' is not a valid placeholder, the generated query will probably fail", MethodSpec.methodBuilder((String)"insert").addAnnotation(AnnotationSpec.builder(Insert.class).addMember("timestamp", "$S", new Object[]{":foo bar"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).build()}, {"Invalid timestamp value: 'foo' is not a bind marker name and can't be parsed as a number literal either, the generated query will probably fail", MethodSpec.methodBuilder((String)"insert").addAnnotation(AnnotationSpec.builder(Insert.class).addMember("timestamp", "$S", new Object[]{"foo"}).build()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addParameter((TypeName)ENTITY_CLASS_NAME, "entity", new Modifier[0]).build()}};
    }
}

